package cz.fidentis.analyst.core;

/**
 * Class holding the upper and lower bounds of an interval.
 * 
 * @author Daniel Schramm
 */
@Deprecated
public class IntValueRange {
    
    private final int minimum, maximum;

    /**
     * Constructor.
     * 
     * @param minimum The lower bound of the interval
     * @param maximum The upper bound of the interval
     * @throws IllegalArgumentException if the {@code minimum} is greater than the {@code maximum}
     */
    public IntValueRange(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("Minimum value must be less or equal to maximum value");
        }
        
        this.minimum = minimum;
        this.maximum = maximum;
    }

    /**
     * Returns the lower bound of the interval.
     * 
     * @return Lower bound of the interval
     */
    public int getMinimum() {
        return minimum;
    }

    /**
     * Returns the upper bound of the interval.
     * 
     * @return Upper bound of the interval
     */
    public int getMaximum() {
        return maximum;
    }
}
