package cz.fidentis.analyst.batch;

import cz.fidentis.analyst.core.ProgressDialog;
import javax.swing.SwingWorker;

/**
 * A task that computes similarity of the set of faces.
 * 
 * @author Radek Oslejsek
 */
public abstract class SimilarityTask extends SwingWorker<Void, Integer> {
    
    private final ProgressDialog progressDialog;
    private final BatchPanel controlPanel;
    
    private double[][] distances;
    
    /**
     * Constructor.
     * 
     * @param progressDialog A window that show the progress of the computation. Must not be {@code null}
     * @param controlPanel A control panel with computation parameters. Must not be {@code null}
     */
    public SimilarityTask(ProgressDialog progressDialog, BatchPanel controlPanel) {
        this.progressDialog = progressDialog;
        this.controlPanel = controlPanel;
        int nFaces = getControlPanel().getFacePaths().size();
        distances = new double[nFaces][nFaces];
    }
    
    @Override
    protected void done() {
        progressDialog.dispose(); // close progess bar
        if (isCancelled()) {
            distances = null;
        }
    }
    
    /**
     * Returns computed 2D matrix of distance similarities or {@code null}
     * @return computed 2D matrix of distance similarities or {@code null}
     */
    public double[][] getDistSimilarities() {
        return distances;
    }
    
    public ProgressDialog getProgressDialog() {
        return progressDialog;
    }

    public final BatchPanel getControlPanel() {
        return controlPanel;
    }
    
    protected void setDistSimilarity(int i, int j, double val) {
        distances[i][j] = val;
    }
}
