package cz.fidentis.analyst.newgui;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import java.util.List;

/**
 * A drawable object, i.e., a mesh model with drawing information like 
 * material, transparency, color, etc. The objects draws itself via provided scene renderer.
 * 
 * @author Radek Oslejsek
 */
public class Drawable {
    
    private final MeshModel model;
    
    /**
     * Constructor. 
     * 
     * @param model Drawable mesh model
     * @throws IllegalArgumentException if the model is {@code null}
     */
    public Drawable(MeshModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
    }
    
    /**
     * Returns list of individual facets.
     * 
     * @return list of individual facets.
     */
    public List<MeshFacet> getFacets() {
        return model.getFacets();
    }
}
