/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.gui.scene.DrawableMesh;
import cz.fidentis.analyst.gui.tab.PostRegistrationCP;
import cz.fidentis.analyst.mesh.io.ModelFileFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.vecmath.Point3d;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui//RegistrationTest//EN",
        autostore = false
)
@TopComponent.Description(
        preferredID = "RegistrationTestTopComponent",
        //iconBase="SET/PATH/TO/ICON/HERE",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS
)
@TopComponent.Registration(mode = "properties", openAtStartup = false)
@ActionID(category = "Window", id = "cz.fidentis.analyst.gui.RegistrationTestTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_RegistrationTestAction",
        preferredID = "RegistrationTestTopComponent"
)
@Messages({
    "CTL_RegistrationTestAction=RegistrationTest",
    "CTL_RegistrationTestTopComponent=RegistrationTest Window",
    "HINT_RegistrationTestTopComponent=This is a RegistrationTest window"
})
public final class RegistrationTestTopComponent extends TopComponent {

    public RegistrationTestTopComponent() {
        initComponents();
        setName(Bundle.CTL_RegistrationTestTopComponent());
        setToolTipText(Bundle.HINT_RegistrationTestTopComponent());
        
        HumanFace primary = null;
        HumanFace secondary = null;
        // choose models
        String[] extensions = new String[2];
        extensions[0] = "obj";
        extensions[1] = "OBJ";
        ModelFileFilter filter = new ModelFileFilter(extensions, "*.obj");
        
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setPreferredSize(new Dimension (800,500));
        jFileChooser1.addChoosableFileFilter(filter);
        jFileChooser1.showOpenDialog(this);
        jFileChooser1.setDialogTitle("Import obj file");
        try {
            primary = new HumanFace(jFileChooser1.getSelectedFile());
        } catch (Exception ex) {}
        jFileChooser1.showOpenDialog(this);
        jFileChooser1.setDialogTitle("Import obj file");
        try {
            secondary = new HumanFace(jFileChooser1.getSelectedFile());
        } catch (Exception ex) {}
        
        canvas1.initScene(primary, secondary);
        // feature points test
        ArrayList<DrawableMesh> drawables = new ArrayList<>(canvas1.getScene().getDrawables());
        DrawableMesh primaryFace = drawables.get(0);
        DrawableMesh secondaryFace = drawables.get(1);
        
        ArrayList<FeaturePoint> primar = new ArrayList<>();
        primar.add(new FeaturePoint(100, 0, 0, null));
        primaryFace.setFeaturePoints(primar);
        
        ArrayList<FeaturePoint> secondar = new ArrayList<>();
        secondar.add(new FeaturePoint(101, 0, 0, null));
        secondaryFace.setFeaturePoints(secondar);
        
        postRegistrationCP1.initPostRegistrationCP(new RegistrationCPEventListener(canvas1));

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        postRegistrationCP1 = new cz.fidentis.analyst.gui.tab.PostRegistrationCP();
        canvas1 = new cz.fidentis.analyst.gui.canvas.Canvas();

        setPreferredSize(new java.awt.Dimension(405, 600));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(postRegistrationCP1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addComponent(canvas1, javax.swing.GroupLayout.PREFERRED_SIZE, 543, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGap(0, 0, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(postRegistrationCP1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                .addContainerGap())
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(layout.createSequentialGroup()
                    .addComponent(canvas1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addContainerGap()))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private cz.fidentis.analyst.gui.canvas.Canvas canvas1;
    private cz.fidentis.analyst.gui.tab.PostRegistrationCP postRegistrationCP1;
    // End of variables declaration//GEN-END:variables
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
}
