package cz.fidentis.analyst.mesh.visitors;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;

/**
 * Visitor for the traversal of @code{MeshModel} and @code{MeshFacet}.
 * 
 * @author oslejsek
 */
public interface Visitor {
    
    
    /**
     * Visits a mesh model.
     * 
     * @param model Mesh model to be visited.
     */
    default void visitMeshModel(MeshModel model) {
        for (MeshFacet facet: model.getFacets()) {
            facet.accept(this);
        }
    }
   
    /**
     * Visits a mesh facet.
     * 
     * @param facet Mesh facet to be visited.
     */
    void visitMeshFacet(MeshFacet facet);
}
