package cz.fidentis.analyst.mesh.visitors;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;

/**
 * Visitor that computes a 3D bounding box (cube).
 * 
 * @author oslejsek
 */
public class BoundingBoxVisitor implements Visitor {

    private BoundingBox bbox;
    
    @Override
    public void visitMeshFacet(MeshFacet facet) {
        if (bbox == null) {
            bbox = new BoundingBox(facet.getVertices());
        } else {
            bbox.compute(facet.getVertices());
        }
    }
    
    /**
     * Returns computed bounding box.
     * @return Bounding box or null
     */
    public BoundingBox getBoundingBox() {
        return bbox;
    }
}
