package cz.fidentis.analyst.mesh;

import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.mesh.io.MeshObjLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

/**
 * This class encapsulates data for 3D scan of a single human face.
 * 
 * @author oslejsek
 */
public class HumanFace {
    
    private MeshModel meshModel;
    
    /**
     * Reads a 3D human phase from file.
     * 
     * @param file OBJ file
     * @throws IOException on I/O failure
     */
    public HumanFace(File file) throws IOException {
        meshModel = MeshObjLoader.read(file);
    }
    
    /**
     * Reads a 3D human phase from file.
     * 
     * @param is input stream with OBJ data
     * @throws IOException on I/O failure
     */
    public HumanFace(InputStream is) throws IOException {
        meshModel = MeshObjLoader.read(is);
    }
    
    /**
     * Returns the triangular mesh model of the human face.
     * 
     * @return the triangular mesh model of the human face
     */
    public MeshModel getMeshModel() {
        return meshModel;
    }
}
