package cz.fidentis.analyst.mesh.visitors;

import cz.fidentis.analyst.mesh.core.CornerTable;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.mesh.core.MeshTriangle;
import java.util.ArrayList;
import java.util.List;

/**
 * Visitor that collects and returs list of triangles.
 * 
 * @author oslejsek
 */
public class TriangleListVisitor implements Visitor {
    
    private List<MeshTriangle> triangles = new ArrayList<>();

    @Override
    public void visitMeshFacet(MeshFacet facet) {
        CornerTable ct = facet.getCornerTable();
        for (int i = 0; i < ct.getSize(); i += 3) {
            triangles.add(new MeshTriangle(
                    facet.getVertex(ct.getRow(i + 0).getVertexIndex()),
                    facet.getVertex(ct.getRow(i + 1).getVertexIndex()),
                    facet.getVertex(ct.getRow(i + 2).getVertexIndex())));
        }
    }
    
    public List<MeshTriangle> getTriangles() {
        return triangles;
    }
}
