package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePointType;
import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 
 * @author Jakub Kolman
 */
public class FeaturePointTypesService {

    private static final String FILE_NAME = "fp_text_default.csv";
    private static final String DELIMETER = ";";

    /**
     * Creates map of feature point types from fp_text_default.csv stored in resources
     * @return Optional map of feature point types mapped by id
     */
    public Optional<Map<Integer, FeaturePointType>> readResources() {
        try (InputStreamReader streamReader =
                     new InputStreamReader(getInputStream(FILE_NAME), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader)) {

            Stream<String> lines = reader.lines();
            Map<Integer, FeaturePointType> featurePointTypes = lines
                .skip(1)
                .map(line -> {
                    Scanner lineScanner = new Scanner(line);
                    lineScanner.useDelimiter(DELIMETER);

                    FeaturePointType featurePointType = new FeaturePointType(lineScanner.nextInt(), lineScanner.next(), lineScanner.next(), lineScanner.next());
                    return featurePointType;
                })
                .collect(Collectors.toMap(FeaturePointType::getType,  Function.identity()));
            return Optional.of(featurePointTypes);

        } catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    /**
     * Creates map of feature point types
     * @param featurePointTypes
     * @return Optional map of feature point types mapped by code
     */
    public Map<String, FeaturePointType> getFeaturepointTypesByCode(Map<Integer, FeaturePointType> featurePointTypes) {
        return featurePointTypes.values()
                .stream()
                .collect(Collectors.toMap(FeaturePointType::getCode,  Function.identity()));
    }

    private InputStream getInputStream(String fileName) {
        FileResourcesUtils app = new FileResourcesUtils();
        return app.getFileFromResourceAsStream(fileName);
    }
}
