package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class used to export feature points to file of csv format
 *
 * @author Jakub Kolman
 */
public class FeaturePointCsvExporter {

    /**
     * Exports a file to set location in csv format <br>
     * File is located and named as {@code objectName}_landmarks.csv
     *
     * @param featurePointList
     * @param objectName
     * @throws IOException
     */
    public static void exportFeaturePointsToCSV(List<FeaturePoint> featurePointList, String objectName) throws IOException {
        File csvOutputFile = new File(String.format("%s_landmarks.csv", objectName));
        writeToFile(featurePointList, csvOutputFile, objectName);
    }

//    /**
//     * This method is only for testing purpose and saves the file only TEMPORARILY. <br>
//     * <p>
//     * Exports a file to set location for testing purpose. To permatently store feature points {@see exportFeaturePointsToCSV}
//     *
//     * @param featurePointList
//     * @param objectName       path + name of file
//     * @throws IOException
//     */
//    public static void testExportFeaturePointsToCSV(List<FeaturePoint> featurePointList, String objectName) throws IOException {
////        File csvOutputFile = new File(String.format("%s_test_landmarks.csv", objectName));
//        File csvOutputFile = File.createTempFile(String.format("%s_test_landmarks", objectName), "csv");
//        writeToFile(featurePointList, csvOutputFile, objectName);
//    }

    /**
     * Handles logic and format of exported csv file
     *
     * @param featurePointList
     * @param csvOutputFile
     * @param objectName
     * @throws IOException
     */
    public static void writeToFile(List<FeaturePoint> featurePointList, File csvOutputFile, String objectName) throws IOException {
        // CSV is a normal text file, need a writer
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(csvOutputFile))) {
            bw.write("Scan name");
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.write(String.format(",%s x", featurePoint.getFeaturePointType().getCode()));
                    bw.write(String.format(",%s y", featurePoint.getFeaturePointType().getCode()));
                    bw.write(String.format(",%s z", featurePoint.getFeaturePointType().getCode()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointCsvExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            bw.newLine();
            bw.write(String.format("%s", objectName));
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getX()));
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getY()));
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getZ()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointCsvExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
    }
}