package cz.fidentis.analyst.kdtree;

import com.google.common.eventbus.Subscribe;

/**
 * Objects implementing this interface can be registered with 
 * a {@link cz.fidentis.analyst.kdtree.KdTree} object 
 * and then be informed when the tree changes.
 * 
 * @author Radek Oslejsek
 */
public interface KdTreeListener {
    
    /**
     * Captures events fired by {@link cz.fidentis.analyst.kdtree.KdTree}.
     * 
     * @param event A fired event.
     */
    @Subscribe
    void kdTreeEvent(KdTreeEvent event);
}
