package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.utils.FeaturePointFileFormatTypes;
import java.io.IOException;
import java.util.List;

/**
 *
 * @author Jakub Kolman
 */
public class FeaturePointImportService {

    private static final String DELIMETER = ".";

    /**
     * Method calls either @see FeaturePointCsvLoader or @see
 FeaturePointFpLoader based on the format taken out of filename
     *
     * @param path
     * @param fileName
     * @return
     * @throws IOException
     */
    public static List<FeaturePoint> importFeaturePoints(String path, String fileName) throws IOException {
        String format = fileName.substring(fileName.lastIndexOf(DELIMETER) + 1);
        switch (format.toUpperCase()) {
            case (FeaturePointFileFormatTypes.FORMAT_TYPE_CSV):
                return FeaturePointCsvLoader.loadFeaturePoints(path, fileName);

            case (FeaturePointFileFormatTypes.FORMAT_TYPE_FP):
                return FeaturePointFpLoader.loadFeaturePoints(path, fileName);

            default:
                return null;
        }
    }

}
