package cz.fidentis.analyst.toolbar;

import cz.fidentis.analyst.symmetry.ProfilesAction;
import cz.fidentis.analyst.symmetry.SymmetryAction;
import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.curvature.CurvatureAction;
import javax.swing.JTabbedPane;

/**
 * A toolbar extension for a single face analysis.
 * 
 * @author Radek Oslejsek
 */
public class SingleFaceToolBar extends RenderingToolBar {
    
    /**
     * Constructor.
     * 
     * @param canvas Rendering canvas
     * @param controlPanel The top component control panels
     */
    public SingleFaceToolBar(Canvas canvas, JTabbedPane controlPanel) {
        super(canvas);
        addPrimaryFaceButton();

        // (Re)render scene after all change listeners have been called
        // (the first added listener is called last)
        controlPanel.addChangeListener(e -> getCanvas().renderScene());

        // Add distance panel to the control panel
        new CurvatureAction(getCanvas(), controlPanel);
        // Add symmetry panel to the control panel
        new SymmetryAction(getCanvas(), controlPanel);
        // Add profiles panel to the control panel
        new ProfilesAction(getCanvas(), controlPanel);

    }
}
