package cz.fidentis.analyst.symmetry;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.core.ControlPanelBuilder;
import org.openide.windows.WindowManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.vecmath.Point3d;

/**
 * Control panel for Polyline profiles and cutting planes
 *
 * @author Dominik Racek
 */
public class ProfilesPanel extends ControlPanel {

    /*
     * GUI primitives holding the configuration state:
     */
    private JTextField cuttingOffset = null;
    private JCheckBox allignFaces;
    private JCheckBox showCuttingPlane;

    /*
     * Handled actions
     */
    public static final String ACTION_COMMAND_SHOW_HIDE_PLANE = "show-hide symmetry plane";
    public static final String ACTION_COMMAND_RECOMPUTE = "recompute";
    public static final String ACTION_COMMAND_EXPORT = "export";

    /*
     * Mandatory design elements
     */
    public static final String ICON = "profiles28x28.png";
    public static final String NAME = "Profiles";

    /**
     * Constructor for one face
     */
    public ProfilesPanel(ActionListener action, List<Point3d> values) {
        setName(NAME);

        ControlPanelBuilder builder = new ControlPanelBuilder(this);

        builder.addPolylinePanel(new PolylinePanel(values));
        builder.addLine();

        buildPanel(action, builder);
    }

    /**
     * Constructor for two faces
     */
    public ProfilesPanel(ActionListener action, List<Point3d> primary, List<Point3d> secondary) {
        setName(NAME);

        ControlPanelBuilder builder = new ControlPanelBuilder(this);

        builder.addPolylinePanel(new PolylinePanel(primary, secondary));
        builder.addLine();

        buildPanel(action, builder);
    }

    private void buildPanel(ActionListener action, ControlPanelBuilder builder) {
        builder.addCaptionLine("Computation options:");
        builder.addLine();

        cuttingOffset = builder.addSliderOptionLine(
                (ActionEvent e) -> {
                    showCuttingOffsetHelp();
                },
                "Cutting Plane Offset",
                -1,
                (ActionEvent e) -> {

                });
        builder.addLine();

        allignFaces = builder.addCheckBoxOptionLine(
                null,
                "Allign faces",
                true,
                null
        );
        builder.addLine();

        builder.addCaptionLine("Computation options:");
        builder.addLine();

        showCuttingPlane = builder.addCheckBoxOptionLine(
                null,
                "Show cutting plane",
                true,
                createListener(action, ACTION_COMMAND_SHOW_HIDE_PLANE)
        );
        builder.addLine();

        builder.addButtons(
                List.of("Recompute",
                        "Export Profiles"),
                List.of(
                        (ActionEvent e) -> {

                        },
                        (ActionEvent e) -> {
                            action.actionPerformed(new ActionEvent(
                                    e.getSource(),
                                    ActionEvent.ACTION_PERFORMED,
                                    ACTION_COMMAND_EXPORT
                            ));
                        }
                )
        );
    }

    @Override
    public ImageIcon getIcon() {
        return getStaticIcon();
    }

    /**
     * Static implementation of the {@link #getIcon()} method.
     *
     * @return Control panel icon
     */
    public static ImageIcon getStaticIcon() {
        return new ImageIcon(ProfilesPanel.class.getClassLoader().getResource("/" + ICON));
    }

    private void showCuttingOffsetHelp() {
        JOptionPane.showMessageDialog(WindowManager.getDefault().findTopComponent("Cutting Plane Offset"),
                "TO DO",
                "TO DO",
                0,
                new ImageIcon(getClass().getResource("/distance.png"))
        );
    }

}
