package cz.fidentis.analyst.core;

import cz.fidentis.analyst.Logger;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Wrapper of the default Java Netbeans Platform output window.
 * This wrapper runs in the worker thread, reads messages logged through 
 * the {@link cz.fidentis.analyst.Logger} and displays them in the output window.
 * 
 * The {@code OutputWindow} is currently executed from 
 * the {@link cz.fidentis.analyst.core.ProjectTopComp}, which is always presented.
 * 
 * @author Radek Oslejsek
 */
public class OutputWindow extends SwingWorker<String, String> {

    private static JTextArea textArea; 
    
    /**
     * Constructor.
     */
    public OutputWindow() {
        TopComponent outputWin = WindowManager.getDefault().findTopComponent("output");
        textArea = new JTextArea();
        JScrollPane sp = new JScrollPane(textArea);
        outputWin.add(sp, BorderLayout.CENTER);
    }

    /**
     * Reads messages of the {@code Logger} in the background and re-sends them
     * the {@link #process(java.util.List)} method.
     * 
     * @return Complete text displayed in the output window.
     * @throws Exception 
     */
    @Override
    protected String doInBackground() throws Exception {
        String line = Logger.reader().readLine();
        while (line != null) {
            publish(line);
            line = Logger.reader().readLine();
        }
        return textArea.getText();
    }
    
    /**
     * Takes text lines process by the {@link #doInBackground()} method and
     * adds them to the output window.
     * 
     * @param chunks process lines
     */
    @Override
    protected void process(List<String> chunks) {
        StringBuilder sb = new StringBuilder();
        sb.append(textArea.getText());
        chunks.forEach(str -> {
            sb.append(str + System.lineSeparator());
        });
        textArea.setText(sb.toString());
    }
        
}
