package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.MeshVisitor;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshTriangle;

import javax.vecmath.Point3d;
import java.util.ArrayList;
import java.util.List;

/**
 * A visitor that calculates the cross-section of a face and a cutting plane.
 * <p>
 * This visitor is thread-safe.
 * </p>
 *
 * @author Dominik Racek
 */
public class CrossSection extends MeshVisitor {
    private List<Point3d> points;
    private MeshFacet plane;

    /**
     *  Constructor
     * @param plane the cutting plane
     */
    public CrossSection(MeshFacet plane) {
        this.plane = plane;
        this.points = new ArrayList<>();
    }

    @Override
    public void visitMeshFacet(MeshFacet facet) {
        //TODO Dont check every triangle, find first and then check it's neighbors and new neighbors and so on
        synchronized (this) {
            Point3d last = null;
            for (MeshTriangle tri : facet) {
                if (tri.checkIntersectionWithPlane(plane)) {
                    Point3d p = facet.getVertex(tri.index1).getPosition();

                    // Check for duplicates
                    if (last != null) {
                        if (last == p) {
                            continue;
                        }
                    }

                    points.add(p);
                    last = p;
                }
            }
        }

    }

    public List<Point3d> getPoints() {
        return points;
    }
}
