package cz.fidentis.analyst.core;

/**
 *
 * @author Daniel Schramm
 */
public class IntValueRange {
    
    private final int minimum, maximum;

    public IntValueRange(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("Minimum value must be less or equal to maximum value");
        }
        
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public int getMinimum() {
        return minimum;
    }

    public int getMaximum() {
        return maximum;
    }
}
