package cz.fidentis.analyst.scene;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import cz.fidentis.analyst.mesh.core.MeshPoint;
import java.awt.Color;
import java.util.List;

/**
 * Points rendered as small spheres.
 * 
 * @author Radek Oslejsek
 */
public class DrawablePointCloud extends Drawable {
    
    public static final Color DEFAULT_COLOR = Color.YELLOW;
    public static final double FP_DEFAULT_SIZE = .7f;
    
    private static final GLU GLU_CONTEXT = new GLU();
    
    private final List<MeshPoint> points;
    
    /**
     * Constructor.
     * 
     * @param points Feature points
     */
    public DrawablePointCloud(List<MeshPoint> points) {
        this.points = points;
        setColor(DEFAULT_COLOR);
    }
    
    @Override
    protected void renderObject(GL2 gl) {
        float[] rgba = {
            getColor().getRed() / 255f, 
            getColor().getGreen() / 255f, 
            getColor().getBlue() / 255f, 
            getTransparency()
        };
        gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, rgba, 0); // set default color
        
        gl.glBegin(GL2.GL_POINTS); 
        points.stream().forEach(mp -> {
            gl.glVertex3d(mp.getX(), mp.getY(), mp.getZ());
            /*
            gl.glPushMatrix(); 
            gl.glTranslated(mp.getX(), mp.getY(), mp.getZ());
            GLUquadric center = GLU_CONTEXT.gluNewQuadric();
            GLU_CONTEXT.gluQuadricDrawStyle(center, GLU.GLU_FILL);
            GLU_CONTEXT.gluQuadricNormals(center, GLU.GLU_FLAT);
            GLU_CONTEXT.gluQuadricOrientation(center, GLU.GLU_OUTSIDE);
            GLU_CONTEXT.gluSphere(center, 0.7, 16, 16);
            GLU_CONTEXT.gluDeleteQuadric(center);
            gl.glPopMatrix();    
            */
        });
        gl.glEnd();
    }
}
