package cz.fidentis.analyst.scene;

import cz.fidentis.analyst.feature.FeaturePoint;
import java.awt.Color;
import java.util.List;

/**
 * Spherical surrounding of feature points that represent their weights.
 * 
 * @author Radek Oslejsek
 */
public class DrawableFpWeights extends DrawableFeaturePoints {
    
    public static final Color FPW_DEFAULT_COLOR = Color.WHITE;
    public static final double FPW_DEFAULT_SIZE = 20f;
    public static final RenderingMode FPW_DEFAULT_RENDERING_MODE = RenderingMode.WIREFRAME;
    
    /**
     * Constructor.
     * 
     * @param featurePoints Feature points
     */
    public DrawableFpWeights(List<FeaturePoint> featurePoints) {
        this(featurePoints, FPW_DEFAULT_COLOR, FPW_DEFAULT_SIZE);
    }
    
    /**
     * Constructor.
     * 
     * @param featurePoints Feature points
     * @param defaultColor Default color
     * @param defaultPerimeter Default perimeter
     */
    public DrawableFpWeights(List<FeaturePoint> featurePoints, Color defaultColor, double defaultPerimeter) {
        super(featurePoints, FPW_DEFAULT_COLOR, FPW_DEFAULT_SIZE);
        setRenderMode(FPW_DEFAULT_RENDERING_MODE);
    }
}
