package cz.fidentis.analyst.project;

import cz.fidentis.analyst.core.ProgressDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

/**
 * A task which opens all tasks from files
 * 
 * @author Matej Kovar
 */
class LoadTasksTask extends SwingWorker<Boolean, Integer> {
    
    private List<File> tasksToOpen;
    private ProgressDialog progressDialog;
    private List<Task> tasksRestored = new ArrayList<>();
    
    /**
     * Constructor for task
     * @param tasksToOpen files with tasks
     * @param progressDialog dialog
     */
    LoadTasksTask(List<File> tasksToOpen, ProgressDialog progressDialog) {
        this.tasksToOpen = tasksToOpen;
        this.progressDialog = progressDialog;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        
        int iter = 0;
        for (var file : tasksToOpen) {
            
            if (isCancelled()) {
                return false;
            }
            
            Task task = Task.restoreFromFile(file);
            tasksRestored.add(task);

            int progress = (int)Math.round(100.0 * (iter + 1) / tasksToOpen.size());
            progressDialog.setValue(progress);
            iter++;
        }
        return true;
        
    }
    
    @Override
    protected void done() {
        progressDialog.dispose();
        
        
        if (isCancelled()) {
            this.tasksRestored.clear();
        }
    }
    
    public List<Task> getTasksRestored() {
        return this.tasksRestored;
    }
}
