package cz.fidentis.analyst.filter;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.core.ProgressDialog;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.feature.FeaturePointType;
import cz.fidentis.analyst.project.ProjectPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author Matej Kovar
 */
public class FilterPanel extends ControlPanel {
    
    private ProjectPanel projectPanel;
    
    private List<FeaturePointType> selectedFeaturePoints = new ArrayList<>();
    
    private FilterHistory filterHistory = new FilterHistory();
    
    private List<FilterSection> sections = new ArrayList<>();
    
    private ActionListener listenerChangeIcon;
            
    public static final String ICON_FILTER_OFF = "filter_off28x28.png";
    public static final String ICON_FILTER_ON = "filter_on28x28.png";
    public static final String NAME = "Filter";

    /**
     * Constructor
     * @param projectPanel ProjectPanel
     */
    public FilterPanel(ProjectPanel projectPanel) {
        this.setName(NAME);
        this.projectPanel = projectPanel;
        initComponents();
        
        featurePointsFilterPanel1.initComponents();
        initSections();
        
        setTableCellRenderer();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        filterPanel = new javax.swing.JPanel();
        byFPLabel = new javax.swing.JLabel();
        hasFPCheckbox = new javax.swing.JCheckBox();
        hasSelectedFPCheckbox = new javax.swing.JCheckBox();
        hasNotFPCheckbox = new javax.swing.JCheckBox();
        featurePointsPanel = new javax.swing.JScrollPane();
        featurePointsFilterPanel1 = new cz.fidentis.analyst.filter.FeaturePointsFilterPanel();
        byNameLabel = new javax.swing.JLabel();
        hasTextCheckbox = new javax.swing.JCheckBox();
        hasTextTextfield = new javax.swing.JTextField();
        hasNotTextCheckbox = new javax.swing.JCheckBox();
        hasNotTextTextfield = new javax.swing.JTextField();
        applyFilterButton = new javax.swing.JButton();
        clearFilteringButton = new javax.swing.JButton();
        revertLastFilteringButton = new javax.swing.JButton();

        filterPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.filterPanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 14))); // NOI18N

        byFPLabel.setFont(new java.awt.Font("Tahoma", 1, 13)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(byFPLabel, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.byFPLabel.text")); // NOI18N

        hasFPCheckbox.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(hasFPCheckbox, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasFPCheckbox.text")); // NOI18N

        hasSelectedFPCheckbox.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(hasSelectedFPCheckbox, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasSelectedFPCheckbox.text")); // NOI18N

        hasNotFPCheckbox.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(hasNotFPCheckbox, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasNotFPCheckbox.text")); // NOI18N

        featurePointsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.featurePointsPanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11))); // NOI18N
        featurePointsPanel.setEnabled(false);

        javax.swing.GroupLayout featurePointsFilterPanel1Layout = new javax.swing.GroupLayout(featurePointsFilterPanel1);
        featurePointsFilterPanel1.setLayout(featurePointsFilterPanel1Layout);
        featurePointsFilterPanel1Layout.setHorizontalGroup(
            featurePointsFilterPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 249, Short.MAX_VALUE)
        );
        featurePointsFilterPanel1Layout.setVerticalGroup(
            featurePointsFilterPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 110, Short.MAX_VALUE)
        );

        featurePointsPanel.setViewportView(featurePointsFilterPanel1);

        byNameLabel.setFont(new java.awt.Font("Tahoma", 1, 13)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(byNameLabel, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.byNameLabel.text")); // NOI18N

        hasTextCheckbox.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(hasTextCheckbox, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasTextCheckbox.text")); // NOI18N

        hasTextTextfield.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasTextTextfield.text")); // NOI18N
        hasTextTextfield.setEnabled(false);

        hasNotTextCheckbox.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(hasNotTextCheckbox, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasNotTextCheckbox.text")); // NOI18N

        hasNotTextTextfield.setText(org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasNotTextTextfield.text")); // NOI18N
        hasNotTextTextfield.setEnabled(false);

        applyFilterButton.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(applyFilterButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.applyFilterButton.text")); // NOI18N
        applyFilterButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyFilterButtonActionPerformed(evt);
            }
        });

        clearFilteringButton.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(clearFilteringButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.clearFilteringButton.text")); // NOI18N
        clearFilteringButton.setEnabled(false);
        clearFilteringButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearFilteringButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(revertLastFilteringButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.revertLastFilteringButton.text")); // NOI18N
        revertLastFilteringButton.setEnabled(false);
        revertLastFilteringButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                revertLastFilteringButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout filterPanelLayout = new javax.swing.GroupLayout(filterPanel);
        filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(
            filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(filterPanelLayout.createSequentialGroup()
                .addGap(47, 47, 47)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(filterPanelLayout.createSequentialGroup()
                        .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(hasSelectedFPCheckbox)
                            .addComponent(hasFPCheckbox)
                            .addComponent(hasNotFPCheckbox))
                        .addGap(51, 51, 51)
                        .addComponent(featurePointsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 261, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(31, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, filterPanelLayout.createSequentialGroup()
                        .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(filterPanelLayout.createSequentialGroup()
                                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(hasTextCheckbox)
                                    .addComponent(hasNotTextCheckbox))
                                .addGap(40, 40, 40)
                                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(hasNotTextTextfield, javax.swing.GroupLayout.DEFAULT_SIZE, 124, Short.MAX_VALUE)
                                    .addComponent(hasTextTextfield, javax.swing.GroupLayout.DEFAULT_SIZE, 124, Short.MAX_VALUE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, filterPanelLayout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addComponent(clearFilteringButton)
                                .addGap(68, 68, 68)))
                        .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(revertLastFilteringButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(applyFilterButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(62, 62, 62))))
            .addGroup(filterPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(byNameLabel)
                    .addComponent(byFPLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        filterPanelLayout.setVerticalGroup(
            filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(filterPanelLayout.createSequentialGroup()
                .addGap(28, 28, 28)
                .addComponent(byFPLabel)
                .addGap(18, 18, 18)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(filterPanelLayout.createSequentialGroup()
                        .addComponent(hasFPCheckbox)
                        .addGap(18, 18, 18)
                        .addComponent(hasSelectedFPCheckbox)
                        .addGap(18, 18, 18)
                        .addComponent(hasNotFPCheckbox))
                    .addComponent(featurePointsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(32, 32, 32)
                .addComponent(byNameLabel)
                .addGap(18, 18, 18)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(hasTextCheckbox)
                    .addComponent(hasTextTextfield, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(hasNotTextCheckbox)
                    .addComponent(hasNotTextTextfield, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 178, Short.MAX_VALUE)
                .addComponent(revertLastFilteringButton)
                .addGap(18, 18, 18)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(applyFilterButton, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(clearFilteringButton, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(48, 48, 48))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(filterPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(filterPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void initSections() {
                
        FilterSection featurePointsSection = new FilterSection();
        featurePointsSection.add(hasFPCheckbox, null);
        featurePointsSection.add(hasSelectedFPCheckbox, featurePointsFilterPanel1);
        featurePointsSection.add(hasNotFPCheckbox, null);
        sections.add(featurePointsSection);
        
        FilterSection nameSection = new FilterSection();
        nameSection.add(hasTextCheckbox, hasTextTextfield);
        nameSection.add(hasNotTextCheckbox, hasNotTextTextfield);
        sections.add(nameSection);
    }
    
    public FilterHistory getFilterHistory() {
        return filterHistory;
    }

    private void clearFilteringButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearFilteringButtonActionPerformed
        clearFiltering();
    }//GEN-LAST:event_clearFilteringButtonActionPerformed

    private void applyFilterButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_applyFilterButtonActionPerformed
        applyFilter();
        clearFilteringButton.setEnabled(!filterHistory.isEmpty());
        listenerChangeIcon.actionPerformed(evt);
        revertLastFilteringButton.setEnabled(!filterHistory.isEmpty());
    }//GEN-LAST:event_applyFilterButtonActionPerformed

    private void revertLastFilteringButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_revertLastFilteringButtonActionPerformed
        
        projectPanel.deselectAllRows();
        
        // sum of rows which were lastly filtered
        int totalRows = filterHistory.revertLastFiltering();
        
        // move rows from the bottom of the table to the beginning of the table
        projectPanel.getModel().unfilterRows(totalRows);
        
        listenerChangeIcon.actionPerformed(evt);
        revertLastFilteringButton.setEnabled(!filterHistory.isEmpty());
        clearFilteringButton.setEnabled(!filterHistory.isEmpty());
        projectPanel.repaint();
    }//GEN-LAST:event_revertLastFilteringButtonActionPerformed
    
    @Override
    public ImageIcon getIcon() {
        if (filterHistory.isEmpty()) {
            return new ImageIcon(FilterPanel.class.getClassLoader().getResource("/" + ICON_FILTER_OFF));
        }
        return new ImageIcon(FilterPanel.class.getClassLoader().getResource("/" + ICON_FILTER_ON));
        
    }
    
    public void setListenerChangeIcon(ActionListener listenerChangeIcon) {
        this.listenerChangeIcon = listenerChangeIcon;
    }

    /**
     * Sets ActionListener to apply filter button
     * @param applyFilterListener ActionListener
     */
    public void setFilterActionListener(ActionListener applyFilterListener) {
        applyFilterButton.addActionListener(applyFilterListener);
        
    }
    
    /**
     * Sets ActionListener to cancel filter mode button
     * @param listenerCancelFilter ActionListener
     */
    public void setCancelFilterActionListener(ActionListener listenerCancelFilter) {
        clearFilteringButton.addActionListener(listenerCancelFilter);
    }
    
    public List<FeaturePointType> getSelectedFeaturePointsFilter() {
        return selectedFeaturePoints;
    }
    
    /**
     * Checks whether face should be filtered based on feature points filter options
     * @param faceName String name of face
     * @return true if face should be filtered, false otherwise
     */
    public boolean applyByFeaturePointsFilter(String faceName) {
        
        boolean hasFP = projectPanel.getProject().hasFPByName(faceName);
        
        // Has some feature point
        if (hasFPCheckbox.isSelected() && !hasFP) {
            return true;
        }
        
        // Has not feature points
        if (hasNotFPCheckbox.isSelected() && hasFP) {
            return true;
        }
        
        // Has selected feature points (from feature points panel)
        if (hasSelectedFPCheckbox.isSelected() && 
                !featurePointsFilterPanel1.getSelectedFeaturePoints().isEmpty()) {
            HumanFace face = projectPanel.getProject().loadFace(faceName);
            
            if (face != null && Collections.disjoint(face.getFeaturePoints().stream()
                    .map(fp -> fp.getFeaturePointType())
                    .collect(Collectors.toList()), featurePointsFilterPanel1.getSelectedFeaturePoints())) {
                return true;
            } 
        }
        
        return false;
    }
    
    /**
     * Checks whether face should be filtered based on name filter options
     * @param faceName String name of face
     * @return true if face should be filtered, false otherwise
     */
    public boolean applyByNameFilter(String faceName) {
        
        // Has text
        if (hasTextCheckbox.isSelected() && !faceName.contains(hasTextTextfield.getText())) {
            return true;
        }
        
        // Has not text
        return hasNotTextCheckbox.isSelected() && faceName.contains(hasNotTextTextfield.getText());
    }
    
    /**
     * Applies given filters to face and checks whether face should be filtered or not
     * @param faceName String name of face
     * @return true if face should be filtered, false otherwise
     */
    public boolean applyFilterOptions(String faceName) {
         
        return applyByFeaturePointsFilter(faceName) || applyByNameFilter(faceName);
        
    }
    
    /**
     * Starts filtering faces based on filter configuration
     */
    public void applyFilter() {
        
        projectPanel.deselectAllRows();

        ProgressDialog progressDialog = new ProgressDialog(filterPanel, "Filtering faces");
        FilterTask task = new FilterTask(projectPanel.getModel(), this, progressDialog);
        
        task.addPropertyChangeListener((PropertyChangeEvent evt) -> {
            if ("state".equals(evt.getPropertyName()) && (SwingWorker.StateValue.DONE.equals(evt.getNewValue()))) {

                // Task finished successfully, remove selected faces
                if (task.getCompleted()) {
                    
                    int total = task.getFilteredRows().size();
                    filterFaces(task.getFilteredRows());
                    
                    JOptionPane.showMessageDialog(filterPanel, 
                            String.format("Filtering done, %d face(s) filtered", total), 
                            "Filter", 
                            JOptionPane.INFORMATION_MESSAGE);  
                    
                }
            }
        });
        progressDialog.runTask(task);
    }
    
    /**
     * Adds filtered (selected) models to the end of the list
     */
    public void filterFaces(List<Integer> filteredRows) {
        
        List<String> selectedFaces = new ArrayList<>();
        Collections.sort(filteredRows, Collections.reverseOrder());
        
        // Moves selected (filtered) faces to the end of the list
        filteredRows.forEach(row -> {
            String faceName = projectPanel.getModel().getValueAt(row, 1).toString();
            selectedFaces.add(faceName);
            projectPanel.getModel().filterRow(row);
        });
        
        filterHistory.addFaces(selectedFaces);
        projectPanel.checkFaceState(null, false);
        projectPanel.repaint();
    }

    /**
     * Cancels filtering
     */
    public void clearFiltering() {
        int totalFaces = filterHistory.clear();
        projectPanel.getModel().unfilterRows(totalFaces);
        
        projectPanel.deselectAllRows();
        projectPanel.repaint();
        
        sections.forEach(section -> {
            section.disableAllComponents();
        });
        revertLastFilteringButton.setEnabled(false);
        clearFilteringButton.setEnabled(false);
        listenerChangeIcon.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));
    }
    
    /**
     * Sets table cell renderer needed for coloring filtered rows
     * If row is filtered, Color.lightGray font color is set
     */
    private void setTableCellRenderer() {
        
        projectPanel.getTable().setDefaultRenderer(String.class, new DefaultTableCellRenderer() {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)  {
                
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                
                if (projectPanel.getModel().getRowCount() > 0) {
                    
                    String faceName = projectPanel.getModel().getValueAt(row, 1).toString();

                    // checks if face in this row is filtered or not and colors text if yes
                    if (row >= projectPanel.getModel().getRowCount() - filterHistory.getTotalFaces()) {
                        c.setForeground(Color.lightGray);
                        projectPanel.getModel().disableRow(row, projectPanel.getProject().getCfg().getPathToFaceByName(faceName));
                        
                    } else {
                        c.setForeground(Color.black);
                        projectPanel.getModel().enableRow(row, projectPanel.getProject().getCfg().getPathToFaceByName(faceName));
                    }
                    
                }
                return c;
            }});
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton applyFilterButton;
    private javax.swing.JLabel byFPLabel;
    private javax.swing.JLabel byNameLabel;
    private javax.swing.JButton clearFilteringButton;
    private cz.fidentis.analyst.filter.FeaturePointsFilterPanel featurePointsFilterPanel1;
    private javax.swing.JScrollPane featurePointsPanel;
    private javax.swing.JPanel filterPanel;
    private javax.swing.JCheckBox hasFPCheckbox;
    private javax.swing.JCheckBox hasNotFPCheckbox;
    private javax.swing.JCheckBox hasNotTextCheckbox;
    private javax.swing.JTextField hasNotTextTextfield;
    private javax.swing.JCheckBox hasSelectedFPCheckbox;
    private javax.swing.JCheckBox hasTextCheckbox;
    private javax.swing.JTextField hasTextTextfield;
    private javax.swing.JButton revertLastFilteringButton;
    // End of variables declaration//GEN-END:variables

}
