package cz.fidentis.analyst.visitors.mesh.sampling;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * No point sampling. All mesh points are returned.
 * 
 * @author Radek Oslejsek
 */
public class NoSampling extends PointSampling {
    
    private List<MeshPoint> allVertices = new ArrayList<>();
    
    @Override
    public void visitMeshFacet(MeshFacet facet) {
        if (facet != null) {
            allVertices.addAll(facet.getVertices());
    }
    }
    
    @Override
    public List<MeshPoint> getSamples() {
        return Collections.unmodifiableList(allVertices);
    }
    
    @Override
    public String toString() {
        return "no downsampling = " + this.getNumDownsampledPoints(allVertices.size()) + " real points";
    }

    
}
