package cz.fidentis.analyst;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

/**
 * This class encapsulates data important for project (re)storing such as paths
 * to faces
 * 
 * @author Matej Kovar
 */
public class ProjectConfiguration {
    
    /* Paths to loaded models */
    private List<Path> paths = new ArrayList<>();

    public List<Path> getPaths() {
        return paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }
       
    /**
     * Adds path to paths
     * @param path Path to be added
     * @return true if path was successfully added 
     */
    public boolean addPath(Path path) {
        if (paths.contains(path)) {
            return false;
        }
        paths.add(path);
        return true;
    }
    
    /**
     * Removes specific path from paths
     * @param name String of face
     */
    public void removePath(String name) {
        paths.removeIf(p -> p.toString().substring(
                p.toString().lastIndexOf(File.separatorChar) + 1, 
                p.toString().lastIndexOf('.')
        ).equals(name));
    }
    
    /**
     * Returns path to face with specified name of file
     * @param name String name of file
     * @return Path to face
     */
    public Path getPathToFaceByName(String name) {        
        for (Path p : paths) {
            if (p.toString().substring(p.toString().lastIndexOf(File.separatorChar) + 1, p.toString().lastIndexOf('.')).equals(name)) {
                return p;
            }
        }
        return null;
    }

    /**
     * Opens all files in paths
     * @return List<File> list of files with faces
     */
    public List<File> openFiles() {
        List<File> f = new ArrayList<>();
            
        paths.forEach(p -> {
            if (p.toFile().exists()) {
                f.add(p.toFile());
            }
        });
        
        return f;
    }
    
    /**
     * Removes all paths
     */
    public void clearPaths() {
        paths.clear();
    }
}
