package cz.fidentis.analyst.visitors.octree;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * This data class is used to hold information about intersections between a
 * ray and a facet
 *
 * @author Enkh-Undral EnkhBayar
 */
public class OctreeArrayIntersectionData {
    private Map<MeshFacet, Map<Integer, RayIntersectionsData>> data = new HashMap<>();

    /**
     * Saves the given data about intersections
     *
     * @param mainFacet facet holding the origin point from which the
     * intersection has been calculated
     * @param index index of the origin point in mainFacet, origin point =
     * mainFacet.getVertex(index)
     * @param intersectionsData data about the intersections
     */
    public void addIntersections(MeshFacet mainFacet, int index, RayIntersectionsData intersectionsData) {
        if (data.containsKey(mainFacet) && data.get(mainFacet).containsKey(index)) {
            data.get(mainFacet).get(index).mergeIntersection(intersectionsData);
        } else if (data.containsKey(mainFacet)) {
            data.get(mainFacet).put(index, intersectionsData);
        } else {
            Map<Integer, RayIntersectionsData> tmp = new HashMap<>();
            tmp.put(index, intersectionsData);
            data.put(mainFacet, tmp);
        }
    }

    /**
     * Returns data about intersections in form of a map
     *
     * @return data about intersections in form of a map
     */
    public Map<MeshFacet, Map<Integer, RayIntersectionsData>> getData() {
        return Collections.unmodifiableMap(data);
    }
}
