package cz.fidentis.analyst.scene;

import com.jogamp.opengl.GL2;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Drawable human face.
 * 
 * @author Radek Oslejsek
 */
public class DrawableFace extends DrawableMesh {
    
    public static final Color SKIN_COLOR_PRIMARY = new Color(224, 172, 105);
    public static final Color SKIN_COLOR_SECONDARY = new Color(236, 188, 180);
    
    private final HumanFace humanFace;
    private boolean renderHeatMap = false;
    
    /**
     * Values at mesh vertices that are to be transferred to colors.
     */
    private Map<MeshFacet, List<Double>> heatmap = new HashMap<>();
    
    public DrawableFace(HumanFace face) {
        super(face.getMeshModel());
        humanFace = face;
        setColor(SKIN_COLOR_PRIMARY);
    }
    
    /**
     * Sets new heatmap.
     * 
     * @param heatmap New heatmap
     */
    public void setHeatMap(Map<MeshFacet, List<Double>> heatmap) {
        this.heatmap = heatmap;
    }
    
    public Map<MeshFacet, List<Double>> getHeatMap() {
        return Collections.unmodifiableMap(heatmap);
    }

    public HumanFace getHumanFace() {
        return humanFace;
    }
    
    /**
     * Sets if the heatmap should be rendered or not.
     * @param render The switch
     */
    public void setRenderHeatmap(boolean render) {
        this.renderHeatMap = render;
    }
    
    /**
     * Determines whether the heatmap is set to be rendered.
     * @return id the heatmap will be rendered
     */
    public boolean isHeatmapRendered() {
        return this.renderHeatMap;
    }
    
    @Override
    protected void renderObject(GL2 gl) {
        if (isHeatmapRendered()) {
            new HeatmapRenderer().drawMeshModel(gl, getModel(), heatmap);
        } else {
            super.renderObject(gl);
        }
    }
    
}
