package cz.fidentis.analyst.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

/**
 * An abstract class for control panels that can be docked in the {@link TopControlPanel}.
 * 
 * @author Radek Oslejsek
 */
public abstract class ControlPanel extends JPanel {
    
    public static final int CONTROL_PANEL_WIDTH = 600;
    
    /*
     * Handled actions
     */
    public static final String ACTION_COMMAND_SHOW_HIDE_PANEL = "show-hide control panel";
    
    /**
     * Returns panel's icon.
     * 
     * @return panel's icon
     */
    public abstract ImageIcon getIcon();
    
    /**
     * Registers action listeners that are invoked when an extrinsic state 
     * of the control panel is changed.
     * 
     * @param action Action listener
     */
    //public void addActionListener(ActionListener action) {
        
    //}
    
    /**
     * Creates and returns action listener that can be connected with a low-level 
     * GUI element (e.g., a button). Action event of the low-level element is then
     * re-directed to the given {@code ControlPanelAction} as given command.
     * 
     * @param action An instance of the {@link ControlPanelAction}
     * @param command Control panel command
     * @return Action listener
     */
    protected final ActionListener createListener(ActionListener action, String command) {
        return new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(new ActionEvent(
                        e.getSource(), 
                        ActionEvent.ACTION_PERFORMED, 
                        command)
                ); 
            }  
        };
    }
    
    protected final ActionListener createListener(ActionListener action, String command, Object data) {
        return new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(new LoadedActionEvent(
                        e.getSource(), 
                        ActionEvent.ACTION_PERFORMED, 
                        command,
                        data)
                ); 
            }  
        };
    }
}
