package cz.fidentis.analyst.newgui.swing;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;

/**
 *
 * @author oslejsek
 */
public class CanvasListener implements GLEventListener {
    
    private Canvas canvas;
    
    /**
     * Constructor.
     * 
     * @param canvas Canvas
     * @throws IllegalArgumentException if the canvas is {@code null}
     */
    public CanvasListener(Canvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas is null");
        }
        this.canvas = canvas;
    }
    
    @Override
    public void init(GLAutoDrawable glad) {
        System.out.println("CanvasListener.init");
        canvas.getScene().initSceneGLContext(glad.getGL().getGL2());
    }

    @Override
    public void dispose(GLAutoDrawable glad) {
    }

    @Override
    public void display(GLAutoDrawable glad) {
        System.out.println("CanvasListener.display");
        canvas.getScene().clearScene();
        canvas.getScene().renderScene();
    }

    @Override
    public void reshape(GLAutoDrawable glad, int x, int y, int width, int height) {
        System.out.println("CanvasListener.reshape");
        canvas.getScene().setViewport(x, y, width, height);
    }
    
}
