package cz.fidentis.analyst.gui.scene;

import com.jogamp.opengl.GL2;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import java.awt.Color;
import java.util.List;
import javax.vecmath.Vector3d;

/**
 * A drawable triangular mesh, i.e., a mesh model with drawing information like 
 * material, transparency, color, relative transformations in the scene etc. 
 * This class encapsulates rendering state and parameters,
 * 
 * @author Radek Oslejsek
 */
public class DrawableMesh {
    
    private final MeshModel model;
    
    private boolean display = true;
    
    // TO DO - R. Pajersky: add transformation attributes and methods
    private Color color = new Color(255, 255, 255);
    private Color highlights = new Color(0, 0, 0, 1);
    private float transparency = 1;
    private Vector3d translation = new Vector3d(0, 0, 0);
    private Vector3d rotation = new Vector3d(0, 0, 0);
    private Vector3d scale = new Vector3d(0, 0, 0);
    private int renderMode = GL2.GL_FILL;
    
    /**
     * Constructor. 
     * 
     * @param model Drawable mesh model
     * @throws IllegalArgumentException if the model is {@code null}
     */
    public DrawableMesh(MeshModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
    }
    
    /**
     * Returns list of individual facets.
     * 
     * @return list of individual facets.
     */
    public List<MeshFacet> getFacets() {
        return model.getFacets();
    }
    
    /**
     * This drawable mesh is included in the rendered scene.
     */
    public void show() {
        display = true;
    }
    
    /**
     * This drawable mesh is excluded from the rendered scene (skipped).
     */
    public void hide() {
        display = false;
    }
    
    /**
     * 
     * @return {@code true} if the object is included (rendered) in the scene.
     */
    public boolean isShown() {
        return display;
    }
    
    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return color;
    }
    
    public float getTransparency() {
        return transparency;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }
    
    public Vector3d getTranslation() {
        return translation;
    }

    public void setTranslation(Vector3d translation) {
        this.translation = translation;
    }

    public Vector3d getRotation() {
        return rotation;
    }

    public void setRotation(Vector3d rotation) {
        this.rotation = rotation;
    }

    public Vector3d getScale() {
        return scale;
    }

    public void setScale(Vector3d scale) {
        this.scale = scale;
    }
    
    public MeshModel getModel() {
        return this.model;
    }

    public Color getHighlights() {
        return highlights;
    }

    public void setHighlights(Color highlights) {
        this.highlights = highlights;
    }
    
    public int getRenderMode() {
        return renderMode;
    }

    public void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
    }
    
}
