package cz.fidentis.analyst.core;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;

/**
 * Utility class for the manipulation with text input fields.
 * 
 * @author Radek Oslejsek
 */
public class TextFieldUtils {
    
    /**
     * Helper method that parses and returns integer from the input field taking
     * Locale into consideration.
     * 
     * @param inputField The input field
     * @return Integer or 0
     */
    public static int parseLocaleInt(JTextField inputField) {
        NumberFormat format = NumberFormat.getInstance(Locale.getDefault());
        try {
            Number number = format.parse(inputField.getText());
            return number.intValue();
        } catch (ParseException ex) {
            return 0;
        }
    }
    
    /**
     * Helper method that parses and returns floating point number from the input field 
     * taking Locale into consideration.
     * 
     * @param inputField The input field
     * @return Double or 0.0
     */
    public static double parseLocaleDouble(JTextField inputField) {
        NumberFormat format = NumberFormat.getInstance(Locale.getDefault());
        try {
            Number number = format.parse(inputField.getText());
            return number.doubleValue();
        } catch (ParseException ex) {
            return 0;
        }
    }
    
    /**
     * Converts number into the text taking into account Locale.
     * 
     * @param value Number
     * @return Text representation of given number
     */
    public static String intToStringLocale(int value) {
        return ""+value;
    }
    
    /**
     * Converts number into the text taking into account Locale.
     * 
     * @param value Number
     * @param fractionDigits Number of digits that are remained in the fraction part of the number
     * @return Text representation of given number
     */
    public static String doubleToStringLocale(double value, int fractionDigits) {
        NumberFormat formatter = DecimalFormat.getInstance(Locale.getDefault());
        formatter.setMinimumFractionDigits(1);
        formatter.setMaximumFractionDigits(fractionDigits);
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        return formatter.format(value);
    }
    
}
