package cz.fidentis.analyst.mesh.events;

import cz.fidentis.analyst.mesh.core.MeshFacet;

/**
 * An event fired by the {@link cz.fidentis.analyst.mesh.core.MeshModel} when 
 * a new mesh facet has been added.

 * @author Radek Oslejsek
 */
public class FacetAddedEvent implements MeshEvent {
    
    private final MeshFacet facet;
    
    /**
     * 
     * @param facet Mesh Facet
     */
    public FacetAddedEvent(MeshFacet facet) {
        this.facet = facet;
    }

    public MeshFacet getFacet() {
        return facet;
    }
}
