package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class used to export feature points to file of fp format
 * 
 * @author Jakub Kolman
 */
public class FeaturePointFpExporter {
    
    /**
     * Exports feature points to file format fp at default location
     * 
     * @param featurePointList
     * @param objectName
     * @throws FileNotFoundException
     * @throws IOException 
     */
        public static void exportFeaturePointsToFP(List<FeaturePoint> featurePointList, String objectName) throws IOException {
        File fpOutputFile = new File(String.format("%s_landmarks.fp", objectName));
        writeToFile(featurePointList, fpOutputFile, objectName);
    }

    public static void writeToFile(List<FeaturePoint> featurePointList, File fpOutputFile, String objectName) throws IOException {
        // CSV is a normal text file, need a writer
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(fpOutputFile))) {
            bw.write(String.format("<!--Saved by software Fidentis Analyst--><facialPoints model=\"%s\">", objectName));
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.newLine();
                    bw.write(String.format("<facialPoint type=\"%s\">", featurePoint.getFeaturePointType().getType()));
                    bw.newLine();
                    bw.write(String.format("<x>%f</x>", featurePoint.getX()));
                    bw.newLine();
                    bw.write(String.format("<y>%f</y>", featurePoint.getY()));
                    bw.newLine();
                    bw.write(String.format("<z>%f</z>", featurePoint.getZ()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointFpExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            bw.newLine();
            bw.write("</facialPoints>");
        }
    }
        
}
