package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.utils.FeaturePointFileFormatTypes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

/**
 * Class used for exporting feature points from file
 *
 * for more details @see
 * cz.fidentis.analyst.feature.services.FeaturePointCsvExporter or @see
 * cz.fidentis.analyst.feature.services.FeaturePointFpExporter
 *
 * @author Jakub Kolman
 */
public class FeaturePointExportService {

    /**
     * Method calls either @see FeaturePointCsvExporter or @see
     * FeaturePointFpExporter based on the format given as parameter
     *
     * @param featurePointList
     * @param objectName
     * @param format
     * @throws FileNotFoundException
     * @throws IOException
     */
    public void exportFeaturePoints(List<FeaturePoint> featurePointList, String objectName, String format) throws FileNotFoundException, IOException {
        switch (format) {
            case FeaturePointFileFormatTypes.FORMAT_TYPE_CSV:
                FeaturePointCsvExporter.exportFeaturePointsToCSV(featurePointList, objectName);
                break;

            case FeaturePointFileFormatTypes.FORMAT_TYPE_FP:
                FeaturePointFpExporter.exportFeaturePointsToFP(featurePointList, objectName);
                break;

            default:
                break;
        }
    }

}
