package cz.fidentis.analyst.toolbar;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.distance.DistanceAction;
import cz.fidentis.analyst.registration.RegistrationAction;
import cz.fidentis.analyst.symmetry.ProfilesAction;
import cz.fidentis.analyst.symmetry.SymmetryAction;

import javax.swing.JTabbedPane;

/**
 * A toolbar extension for the analysis of two faces.
 * 
 * @author Radek Oslejsek
 * @author Daniel Schramm
 */
public class FaceToFaceToolBar extends RenderingToolBar {
    
    /**
     * Constructor.
     * 
     * @param canvas Rendering canvas
     * @param controlPanel The top component control panels
     */
    public FaceToFaceToolBar(Canvas canvas, JTabbedPane controlPanel) {
        super(canvas);
        addPrimaryFaceButton();
        addSecondaryFaceButton();

        
        // (Re)render scene after all change listeners have been called
        // (the first added listener is called last)
        controlPanel.addChangeListener(e -> getCanvas().renderScene());
        
        // Add distance panel to the control panel
        new DistanceAction(getCanvas(), controlPanel);
        // Add registration panel to the control panel
        new RegistrationAction(getCanvas(), controlPanel);
        // Add symmetry panel to the control panel
        new SymmetryAction(getCanvas(), controlPanel);
        // Add profiles panel to the control panel
        new ProfilesAction(getCanvas(), controlPanel);
    }
}
