package cz.fidentis.analyst.core;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.toolbar.FaceToFaceToolBar;
import cz.fidentis.analyst.toolbar.RenderingToolBar;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.windows.TopComponent;

/**
 * The non-singleton window/tab for the analysis of two faces.
 *
 * @author Radek Oslejsek
 */
public class FaceToFaceTab extends TopComponent {
    
    private final Canvas canvas ;
    private final FaceToFaceToolBar renderingToolBar;
    private final TopControlPanel controlPanel;
    private final JScrollPane scrollPane;

    /**
     * Constructor.
     * @param primary Primary face
     * @param secondary Secondary face
     * @param name Tab name
     */
    public FaceToFaceTab(HumanFace primary, HumanFace secondary, String name) {
        canvas = new Canvas();
        canvas.initScene(primary, secondary);
        controlPanel = new TopControlPanel();
        renderingToolBar = new FaceToFaceToolBar(canvas, controlPanel);
        
        scrollPane = new JScrollPane(controlPanel);
        
        setName(name);
        initComponents();
        
        // change the height so that it corresponds to the height of the OpenGL window
        canvas.addComponentListener(new ComponentAdapter() {
            @Override
            public void componentResized(ComponentEvent e) {
                scrollPane.setSize(ControlPanel.CONTROL_PANEL_WIDTH, canvas.getHeight());
            }
        });
    }
    
    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER; // TO DO: change to .PERSISTENCE_ONLY_OPENED when we can re-create the ProjectTC
    }
    
    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(canvas, GroupLayout.DEFAULT_SIZE, 651, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(renderingToolBar, GroupLayout.PREFERRED_SIZE, RenderingToolBar.WIDTH, GroupLayout.PREFERRED_SIZE)
                                .addComponent(
                                        scrollPane,
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH
                                )
                        )
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createBaselineGroup(true, true)
                                        .addComponent(canvas)
                                        .addComponent(renderingToolBar)
                                        .addComponent(scrollPane)
                                ))
        );
    }

    public Canvas getCanvas() {
        return canvas;
    }
    
}
