package cz.fidentis.analyst.project;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.scene.Camera;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.Paths;

/**
 *
 * @author Matej Kovar
 */
public class Task implements Serializable {
    
    private HumanFace primary = null;
    private HumanFace secondary = null;
    private Camera camera = null;

    /**
     * Constructor for task
     * @param primary human face
     * @param secondary human face (or null)
     * @param camera camera
     */
    public Task(HumanFace primary, HumanFace secondary, Camera camera) {
        this.primary = primary;
        this.secondary = secondary;
        this.camera = camera;
    }

    public HumanFace getPrimary() {
        return primary;
    }

    public void setPrimary(HumanFace primary) {
        this.primary = primary;
    }

    public HumanFace getSecondary() {
        return secondary;
    }

    public void setSecondary(HumanFace secondary) {
        this.secondary = secondary;
    }

    public Camera getCamera() {
        return camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }
    
        
    /**
     * Serializes data into file
     * @param pathToProjectDirectory path to project directory
     * @return file where data is stored
     * @throws IOException exception
     */
    public File dumpToFile(String pathToProjectDirectory) throws IOException {
        
        File projectDirectory = Paths.get(pathToProjectDirectory).toFile();
        
        String name = primary.getShortName();
        if (secondary != null) {
            name = primary.getShortName() + "_TO_" + secondary.getShortName();
        }
        
        File file = new File(projectDirectory.toString() + File.separatorChar + name + ".bin");
        //file.deleteOnExit();
        
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try (ObjectOutputStream fos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(raf.getFD())))) {
            fos.writeObject(this);
            fos.flush();
        }
        return file;   
    }
    
    /**
     * Restores serialized data from file
     * @param dumpFile file with serialized data
     * @return instance of Task class with primary, secondary and camera
     * @throws IOException
     * @throws ClassNotFoundException
     */
    public static Task restoreFromFile(File dumpFile) throws IOException, ClassNotFoundException {
        
        try (ObjectInputStream fos = new ObjectInputStream(new BufferedInputStream(new FileInputStream(dumpFile)))) {
            return (Task) fos.readObject();
        }
        
    }
    
    /**
     * Tries to delete task from disc
     * @param pathToTask path to task
     */
    public static void endTask(String pathToTask) {
        File file = new File(pathToTask);
        
        if (file.exists()) {
            file.delete();
        }
    }    
}
