package cz.fidentis.analyst.canvas.toolbar;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.scene.RenderingMode;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.util.NbBundle;

/**
 * Canvas toolbox for the selection of rendering mode.
 * 
 * @author Radek Oslejsek
 * @author Katerina Zarska
 */
public class RenderingModeToolbox extends JPopupMenu {
    
    private static final String TEXTURE_BUTTON_ICON = "texture-tri28x28.png";
    private static final String SMOOT_BUTTON_ICON = "smooth-tri28x28.png";
    private static final String WIREFRAME_BUTTON_ICON = "wireframe-tri28x28.png";
    private static final String POINTS_BUTTON_ICON = "points-tri28x28.png";
    
    private final Canvas canvas;
    
    /**
     * Constructor.
     * @param canvas Rendering canvas
     */
    public RenderingModeToolbox(Canvas canvas) {
        this.canvas = canvas;
        initComponents();
    }
    
    private void initComponents() {
        JMenuItem menuItem1 = new JMenuItem(new AbstractAction() { // fill
            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.getScene().getDrawableFaces().forEach(f -> {
                    f.setRenderMode(RenderingMode.SMOOTH);
                });
                canvas.renderScene();
            }
        });
        
        JMenuItem menuItem2 = new JMenuItem(new AbstractAction() { // lines
            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.getScene().getDrawableFaces().forEach(f -> {
                   f.setRenderMode(RenderingMode.WIREFRAME);
                });
                canvas.renderScene();
            }
        });
        
        JMenuItem menuItem3 = new JMenuItem(new AbstractAction() { // points
            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.getScene().getDrawableFaces().forEach(f -> {
                   f.setRenderMode(RenderingMode.POINT_CLOUD);
                });
                canvas.renderScene();
            }
        });
        
        JMenuItem menuItem4 = new JMenuItem(new AbstractAction() { // texture
            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.getScene().getDrawableFaces().forEach(f -> {
                   f.setRenderMode(RenderingMode.TEXTURE);
                });
                canvas.renderScene();
            }
        });
        
        menuItem1.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.SMOOT_BUTTON_ICON)));
        menuItem2.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.WIREFRAME_BUTTON_ICON)));
        menuItem3.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.POINTS_BUTTON_ICON)));
        menuItem4.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.TEXTURE_BUTTON_ICON)));

        menuItem1.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.smooth.text"));
        menuItem2.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.wireframe.text"));
        menuItem3.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.pointcloud.text"));
        menuItem4.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.texture.text"));
        
        add(menuItem4);
        add(menuItem1);
        add(menuItem2);
        add(menuItem3);
        
        setLayout(new GridLayout(1,0));
    }
}
