package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshTriangle;
import java.util.List;
import javax.vecmath.Vector3d;

/**
 * Calculates Gaussian curvatures of mesh vertices.
 * 
 * @author Natalia Bebjakova
 * @author Radek Oslejsek
 */
public class GaussianCurvature extends Curvature {
    
    protected double calculateCurvature(MeshFacet facet, List<MeshTriangle> triangles, int centerIndex) {
        List<Integer> neighbouringTriangles = facet.getCornerTable().getTriangleIndexesByVertexIndex(centerIndex);
        
        if (neighbouringTriangles.isEmpty()) {
            return Double.NaN;
        }
        
        double sum = 2 * Math.PI;
        double areaSum = 0;

        // fro all surrounding triangles:
        List<Vector3d> voronoiPoints = facet.calculateVoronoiPoints();
        for (int i = 0; i < neighbouringTriangles.size(); i++) {
            Vector3d v1 = new Vector3d();
            Vector3d v2 = new Vector3d();
            MeshTriangle tri = triangles.get(neighbouringTriangles.get(i));
            Vector3d voronoiPoint = voronoiPoints.get(neighbouringTriangles.get(i));
            
            double area = 0;
            if (tri.vertex1 ==  facet.getVertex(centerIndex)) {
                v1 = new Vector3d(tri.vertex2.getPosition());
                v2 = new Vector3d(tri.vertex3.getPosition());
                v1.sub(tri.vertex1.getPosition());
                v2.sub(tri.vertex1.getPosition());
                area = voronoiPoint.x;
            } else if (tri.vertex2 == facet.getVertex(centerIndex)) {
                v1 = new Vector3d(tri.vertex1.getPosition());
                v2 = new Vector3d(tri.vertex3.getPosition());
                v1.sub(tri.vertex2.getPosition());
                v2.sub(tri.vertex2.getPosition());
                area = voronoiPoint.y;
            } else if (tri.vertex3 == facet.getVertex(centerIndex)) {
                v1 = new Vector3d(tri.vertex2.getPosition());
                v2 = new Vector3d(tri.vertex1.getPosition());
                v1.sub(tri.vertex3.getPosition());
                v2.sub(tri.vertex3.getPosition());
                area = voronoiPoint.z;
            }
            
            areaSum += area;
            v1.normalize();
            v2.normalize();
            
            sum -= Math.acos(v1.dot(v2));
        } 
        double value = sum * (1.0 / areaSum);
        
        return value;        
    }
}
