/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.gui.canvas.Canvas;
import cz.fidentis.analyst.gui.scene.DrawableMesh;
import cz.fidentis.analyst.visitors.mesh.BoundingBox;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/**
 * Executes changes made in PostRegistrationCP
 * 
 * @author Richard Pajersky
 */
public class RegistrationCPEventListener {
    
    private final Canvas canvas;
    private final Color defaultPrimaryColor = new Color(51, 51, 153);
    private final Color defaultSecondaryColor = new Color(255, 239, 0);
    private final int transparencyRange = 10;
    private final double changeAmount = 500d;
    private final double moveX;
    private final double moveY;
    private final double moveZ;
    private final double scaleXYZ;
    
    private DrawableMesh primaryFace;
    private DrawableMesh secondaryFace;
    
    public RegistrationCPEventListener(Canvas canvas) {
        this.canvas = canvas;
        
        ArrayList<DrawableMesh> drawables = new ArrayList<>(canvas.getScene().getDrawables());
        primaryFace = drawables.get(0);
        secondaryFace = drawables.get(1);
        setDeafultColor();
        
        // set change amounts
        BoundingBox visitor = new BoundingBox();
        secondaryFace.getModel().compute(visitor);
        Point3d maxPoint = visitor.getBoundingBox().getMaxPoint();
        Point3d minPoint = visitor.getBoundingBox().getMinPoint();
        moveX = (maxPoint.x - minPoint.x) / changeAmount;
        moveY = (maxPoint.y - minPoint.y) / changeAmount;
        moveZ = (maxPoint.z - minPoint.z) / changeAmount;
        scaleXYZ = (visitor.getBoundingBox().getMaxDiag() / (10 * changeAmount));
    }
    
    public final void setDeafultColor() {
        primaryFace.setColor(defaultPrimaryColor);
        secondaryFace.setColor(defaultSecondaryColor);
    }
    
    public int getTransparencyRange() {
        return transparencyRange;
    }
    
    public void setPrimaryColor(Color color) {
        primaryFace.setColor(color);
        canvas.renderScene();
    }

    public void setSecondaryColor(Color color) {
        secondaryFace.setColor(color);
        canvas.renderScene();
    }
    
    public Color getPrimaryColor() {
        return primaryFace.getColor();
    }

    public Color getSecondaryColor() {
        return secondaryFace.getColor();
    }
    
    public void setTransparency(int value) {
        
        if (value == transparencyRange) {
            setPrimaryTransparency(1);
            setSecondaryTransparency(1);
        }
        if (value < transparencyRange) {
            setPrimaryTransparency(value / 10f);
            setSecondaryTransparency(1);
        }
        if (value > transparencyRange) {
            setSecondaryTransparency((2 * transparencyRange - value) / 10f);
            setPrimaryTransparency(1);
        }
        canvas.renderScene();
    }
    
    public void setPrimaryTransparency(float transparency) {
        primaryFace.setTransparency(transparency);
    }

    public void setSecondaryTransparency(float transparency) {
        secondaryFace.setTransparency(transparency);
    }
    
    public double getPrimaryTransparency() {
        return primaryFace.getTransparency();
    }

    public double getSecondaryTransparency() {
        return secondaryFace.getTransparency();
    }
    
    public void setFrontFacing() {
        canvas.getCamera().initLocation();
        canvas.renderScene();
    }
    
    public void setSideFacing() {
        canvas.getCamera().initLocation();
        canvas.getCamera().rotate(0, 90);
        canvas.renderScene();
    }
    
    public Color getDefaultPrimaryColor() {
        return defaultPrimaryColor;
    }

    public Color getDefaultSecondaryColor() {
        return defaultSecondaryColor;
    }
    
    public void resetTranslation() {
        secondaryFace.setTranslation(new Vector3d(0, 0, 0));
        canvas.renderScene();
    }
    
    public void resetRotation() {
        secondaryFace.setRotation(new Vector3d(0, 0, 0));
        canvas.renderScene();
    }

    public void resetScale() {
        secondaryFace.setScale(new Vector3d(0, 0, 0));
        canvas.renderScene();
    }
    
    public void setXTranslation(double value) {
        secondaryFace.getTranslation().x = value * moveX;
        canvas.renderScene();
    }
    
    public void setYTranslation(double value) {
        secondaryFace.getTranslation().y = value * moveY;
        canvas.renderScene();
    }
        
    public void setZTranslation(double value) {
        secondaryFace.getTranslation().z = value * moveZ;
        canvas.renderScene();
    }
    
    public void setXRotation(double value) {
        secondaryFace.getRotation().x = value * moveX;
        canvas.renderScene();
    }
    
    public void setYRotation(double value) {
        secondaryFace.getRotation().y = value * moveY;
        canvas.renderScene();
    }
        
    public void setZRotation(double value) {
        secondaryFace.getRotation().z = value * moveZ;
        canvas.renderScene();
    }
    
    public void setScale(double value) {
        secondaryFace.getScale().x = value * scaleXYZ;
        secondaryFace.getScale().y = value * scaleXYZ;
        secondaryFace.getScale().z = value * scaleXYZ;
        canvas.renderScene();
    }
}
