package cz.fidentis.analyst.mesh.material;

import javax.media.j3d.Texture;
import javax.vecmath.Vector3d;

/**
 * Argument for Material constructor
 *
 * @author Matej Lukes
 */
public class MaterialConstructorArguments {
    private String name;

    // colour info
    private Vector3d ambient, diffuse, specularColors;
    private double shininess, alpha,  illumination;

    // texture info
    private String textureFileName;
    private Texture texture;

    /**
     * @param illumination illumination of material
     */
    public void setIllumination(double illumination) {
        this.illumination = illumination;
    }

    /**
     *
     * @return illumination
     */
    public double getIllumination() {
        return illumination;
    }

    /**
     *
     * @param alpha alpha of material
     */
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    /**
     *
     * @return alpha
     */
    public double getAlpha() {
        return alpha;
    }

    /**
     *
     * @param shininess shininess of material
     */
    public void setShininess(float shininess) {
        this.shininess = shininess;
    }

    /**
     *
     * @return shininess
     */
    public double getShininess() {
        return shininess;
    }

    /**
     *
     * @param ambient ambient of material
     */
    public void setAmbient(Vector3d ambient) {
        this.ambient = ambient;
    }

    /**
     *
     * @return ambient
     */
    public Vector3d getAmbient() {
        return ambient;
    }

    /**
     *
     * @param diffuse diffuse of material
     */
    public void setDiffuse(Vector3d diffuse) {
        this.diffuse = diffuse;
    }

    /**
     *
     * @return diffuse
     */
    public Vector3d getDiffuse() {
        return diffuse;
    }

    /**
     *
     * @param specularColors specular colors of material
     */
    public void setSpecularColors(Vector3d specularColors) {
        this.specularColors = specularColors;
    }

    /**
     *
     * @return specular colors
     */
    public Vector3d getSpecularColors() {
        return specularColors;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    /**
     *
     * @return texture
     */
    public Texture getTexture() {
        return texture;
    }

    /**
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name of material
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return name of texture file
     */
    public String getTextureFileName() {
        return textureFileName;
    }

    /**
     * @param textureFileName name of file of material texture
     */
    public void setTextureFileName(String textureFileName) {
        this.textureFileName = textureFileName;
    }

}
