package cz.fidentis.analyst.icp;

import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

/**
 * IcpTransformation class is holding computed data for transformation.
 *
 * @author Maria Kocurekova
 */
public class IcpTransformation {

    private final Quat4d rotation;
    private final double scaleFactor;
    private final Vector3d translation;
    private final double meanD;

    /**
     * Constructor for IcpTransformation.
     *
     * @param translation Translation represents translation of ComputedFacet on x, y, z axis.
     * @param rotation Rotation is represented by Quaternion
     *                 (x, y, z coordinate and scalar component).
     * @param scaleFactor ScaleFactor represents scale between two objects.
     *                    In case there is no scale the value is 0.
     * @param meanD MeanD represents mean distance between objects.
     */
    public IcpTransformation(Vector3d translation, Quat4d rotation, double scaleFactor,double meanD) {
        this.translation = translation;
        this.scaleFactor = scaleFactor;
        this.rotation = rotation;
        this.meanD = meanD;
    }

    /**
     * Getter for rotation.
     * @return Return rotation parameter.
     */
    public Quat4d getRotation() {
        return rotation;
    }

    /**
     * Getter for scale.
     * @return Return scale factor.
     */
    public double getScaleFactor() {
        return scaleFactor;
    }

    /**
     * Getter for translation.
     * @return Return translation parameter.
     */
    public Vector3d getTranslation() {
        return translation;
    }

    /**
     * Getter for mean distance.
     * @return Return mean distance parameter.
     */
    public double getMeanD() {
        return meanD;
    }
}
