package cz.fidentis.analyst.toolbar;

import cz.fidentis.analyst.symmetry.SymmetryAction;
import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.curvature.CurvatureAction;
import cz.fidentis.analyst.curvature.CurvaturePanel;
import cz.fidentis.analyst.symmetry.SymmetryPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import org.openide.util.NbBundle;

/**
 * A toolbar extension for a single face analysis.
 * 
 * @author Radek Oslejsek
 */
public class SingleFaceToolBar extends RenderingToolBar {
    
    /**
     * Constructor.
     * 
     * @param canvas Rendering canvas
     * @param controlPanel The top component control panels
     */
    public SingleFaceToolBar(Canvas canvas, JTabbedPane controlPanel) {
        super(canvas);
        addPrimaryFaceButton();
        addSeparator();
        addSymmetryPlaneButton(controlPanel);
        addCurvatureButton(controlPanel);
    }
    
    private void addSymmetryPlaneButton(JTabbedPane controlPanel) {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new SymmetryAction(getCanvas(), controlPanel));
        button.setActionCommand(ControlPanel.ACTION_COMMAND_SHOW_HIDE_PANEL);
        button.setIcon(SymmetryPanel.getStaticIcon());
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "SingleFaceToolBar.symmetry.text"));
        add(button);
    }
    
    private void addCurvatureButton(JTabbedPane topControlPanel) {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new CurvatureAction(getCanvas(), topControlPanel));
        button.setActionCommand(ControlPanel.ACTION_COMMAND_SHOW_HIDE_PANEL);
        button.setIcon(CurvaturePanel.getStaticIcon());
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "SingleFaceToolBar.curvature.text"));
        add(button);
    }
}
