package cz.fidentis.analyst.core;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.toolbar.RenderingToolBar;
import cz.fidentis.analyst.toolbar.SingleFaceToolBar;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle;
import org.openide.windows.TopComponent;

/**
 * The non-singleton window/tab for detail inspection of a single face.
 *
 * @author Radek Oslejsek
 */
public final class SingleFaceTab extends TopComponent {
    
    private final Canvas canvas;
    private final RenderingToolBar renderingToolBar;
    private final TopControlPanel controlPanel;
    
    /**
     * Constructor.
     * @param face Face
     * @param name Tab name
     */
    public SingleFaceTab(HumanFace face, String name) {
        canvas = new Canvas();
        canvas.initScene(face);
        controlPanel = new TopControlPanel();
        renderingToolBar = new SingleFaceToolBar(canvas, controlPanel);
        setName(name);
        initComponents();
    }
    
    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER; // TO DO: change to .PERSISTENCE_ONLY_OPENED when we can re-create the ProjectTC
    }
    
    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(canvas, GroupLayout.DEFAULT_SIZE, 651, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(renderingToolBar, GroupLayout.PREFERRED_SIZE, RenderingToolBar.WIDTH, GroupLayout.PREFERRED_SIZE)
                                .addComponent(
                                        controlPanel, 
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH
                                )
                        )
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createBaselineGroup(true, true)
                                        .addComponent(canvas)
                                        .addComponent(renderingToolBar)
                                        .addComponent(controlPanel)
                                ))
        );
    }

    public Canvas getCanvas() {
        return canvas;
    }
}
