package cz.fidentis.analyst.face;

import cz.fidentis.analyst.icp.IcpVisitor;
import cz.fidentis.analyst.icp.UndersamplingStrategy;
import cz.fidentis.analyst.kdtree.KdTree;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author Radek Oslejsek
 */
public class BatchProcessor {
    
    /**
     * Cache of all faces, including the processed faces.
     */
    //private final HumanFaceCache cache;
    
    /**
     * IDs of registered (transformed) faces.
     */
    private final List<String> processedFaces = new ArrayList<>();
    
    /**
     * Template face computed by averaging vertices processed faces.
     */
    private HumanFace templateFace = null;
    
    public HumanFace getAvgTemplateFace() {
        return templateFace;
    }
    
    public void registerToGivenFace(String primaryFacePath, List<String> faces, int iters, double error, UndersamplingStrategy strategy) {
        if (faces == null) {
            throw new IllegalArgumentException("faces");
        }
        
        HumanFace primaryFace = pathToFace(primaryFacePath);
        
        HumanFaceFactory.instance().setStrategy(HumanFaceFactory.Strategy.MRU);
        KdTree kdTree = primaryFace.computeKdTree(true);
        for (String facePath: faces) {
            String faceId = HumanFaceFactory.instance().loadFace(new File(facePath));
            if (primaryFace.getId().equals(faceId)) { // skip the same face
                processedFaces.add(faceId);
                continue;
            }
            
            HumanFace face = HumanFaceFactory.instance().getFace(faceId);
            IcpVisitor icpVisitor = new IcpVisitor(kdTree, iters, true, error, strategy);
            face.getMeshModel().compute(icpVisitor);
        }
    }
    
    public void registerToTemplateFace(String initTempPath, List<String> faces, int iters, double error, UndersamplingStrategy strategy) {
        if (faces == null) {
            throw new IllegalArgumentException("faces");
        }
        
        try {
            this.templateFace = new HumanFace(new File(initTempPath));
        } catch (IOException ex) {
            throw new IllegalArgumentException("initTempPath", ex);
        }
        
        // TO DO
    }
    
    public void computeTemplateFaceOnly(String initTempPath, List<String> faces) {
        if (faces == null) {
            throw new IllegalArgumentException("faces");
        }
        
        this.templateFace = pathToFace(initTempPath);
        
        HumanFaceFactory.instance().setStrategy(HumanFaceFactory.Strategy.MRU);
        AvgFaceConstructor constructor = new AvgFaceConstructor(this.templateFace.getMeshModel());
        for (String facePath: faces) {
            String faceId = HumanFaceFactory.instance().loadFace(new File(facePath));
            if (this.templateFace.getId().equals(faceId)) { // skip the same face
                processedFaces.add(faceId);
                continue; 
            }
        
            HumanFace face = HumanFaceFactory.instance().getFace(faceId);
            face.computeKdTree(false).accept(constructor);
        }
        
        this.templateFace.setMeshModel(constructor.getAveragedMeshModel());
    }
    
    protected HumanFace pathToFace(String path) {
        try {
            return new HumanFace(new File(path));
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
    
}
