package cz.fidentis.analyst.project;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.core.OutputWindowThread;
import cz.fidentis.analyst.core.TopControlPanel;
import cz.fidentis.analyst.gui.Installer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.util.NbBundle.Messages;
import org.openide.windows.TopComponent;

/**
 * The main panel enabling analysts to select the primary and secondary faces,
 * and to perform basic batch processing. This panel also serves as an entry
 * point for detailed face analysis and face-to-face comparison.
 *
 * @author Matej Kovar
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui//Dashboard//EN",
        autostore = false
)
@TopComponent.Description(
        preferredID = "ProjectTopComp",
        //iconBase="SET/PATH/TO/ICON/HERE",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS
)
@TopComponent.Registration(mode = "editor", openAtStartup = true)
@ActionID(category = "Window", id = "cz.fidentis.analyst.gui.ProjectTopComp")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_ProjectTopCompAction",
        preferredID = "ProjectTopComp"
)
@Messages({
    "CTL_ProjectTopCompAction=Project",
    "CTL_ProjectTopCompTopComponent=Project",
    "HINT_ProjectTopCompTopComponent=This is a Project window"
})
public final class ProjectTopComp extends TopComponent {
    
    private final ProjectPanel projectPanel;
    private final TopControlPanel controlPanel;
    private final JScrollPane projectPanelScrollPane;
    private final JScrollPane controlPanelScrollPane;
    
    /**
     * Project Top Component
     */
    public ProjectTopComp() {
        
        setName(Bundle.CTL_ProjectTopCompTopComponent());
        setToolTipText(Bundle.HINT_ProjectTopCompTopComponent());
        putClientProperty(TopComponent.PROP_CLOSING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_DRAGGING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_UNDOCKING_DISABLED, Boolean.TRUE);
        
        projectPanel = new ProjectPanel();
        controlPanel = new TopControlPanel();
        projectPanelScrollPane = new JScrollPane(projectPanel);
        controlPanelScrollPane = new JScrollPane(controlPanel);
        
        initComponents();
        
        
        OutputWindowThread.execute();
        
        // Face State Panel
        
        // Listener for loading currently selected face (to show face state)
        ActionListener listenerLoadFace = (ActionEvent e) -> {
            projectPanel.loadCurrentlySelectedFace();
        };
        
        FaceStatePanel facePanel = new FaceStatePanel(listenerLoadFace);
        this.controlPanel.addTab(facePanel.getName(), facePanel.getIcon(), facePanel);
        this.controlPanel.setSelectedComponent(facePanel);
        projectPanel.setFaceStatePanel(facePanel);
        
        // Filter Panel
        
        // Listener for loading all faces - to enable filtering
        ActionListener listenerLoadAllFaces = (ActionEvent e) -> {
            projectPanel.loadAllFaces();
        };
        
        FilterPanel filterPanel = new FilterPanel(listenerLoadAllFaces);
        this.controlPanel.addTab(filterPanel.getName(), filterPanel.getIcon(), filterPanel);
        
        // Listener for applying filter on faces
        ActionListener listenerFilter = (ActionEvent e) -> {
            projectPanel.applyFilter(filterPanel.isFeaturePointsFilter(), filterPanel.isKdTreeFilter(), filterPanel.isAlphabeticalFilter());
        };
        
        filterPanel.setFilterActionListener(listenerFilter);
        projectPanel.setFilterPanel(filterPanel);
        
        this.openAtTabPosition(0);
        this.toFront();
        this.requestActive();
        
        // Asks user whether he wants to create new project or open existing
        projectPanel.openExistingOrNewProject();
        
        // Pass this class to installer so it can call method of this class on close
        Installer inst = new Installer(this);
    }
    
        private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(projectPanelScrollPane, GroupLayout.DEFAULT_SIZE, 651, Short.MAX_VALUE)
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
//                                .addComponent(renderingToolBar, GroupLayout.PREFERRED_SIZE, RenderingToolBar.WIDTH, GroupLayout.PREFERRED_SIZE)
                                .addComponent(
                                        controlPanelScrollPane,
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH, 
                                        ControlPanel.CONTROL_PANEL_WIDTH
                                )
                        )
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createBaselineGroup(true, true)
                                        .addComponent(projectPanelScrollPane)
//                                        .addComponent(renderingToolBar)
                                        .addComponent(controlPanelScrollPane)
                                ))
        );
    }
    
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
    
    
    /**
     * Checks whether currently opened project is saved or not and asks user
     * whether he wants to save it or not on close
     */
    public void saveProjectOnClose() {
        if (!projectPanel.isProjectSaved()) {

            int save = JOptionPane.showConfirmDialog(null,
                    "Project is not saved. Would you like to save project?", "Save project", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

            if (save == JOptionPane.YES_OPTION) {
                projectPanel.saveProject();
            }
        }
    }
}
