package cz.fidentis.analyst.project;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.face.HumanFace;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

/**
 *
 * @author Matej Kovar
 */
public class FaceStatePanel extends ControlPanel {

    private final ImageIcon notCheck = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "notCheck16x16.png"));
    private final ImageIcon check = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "check16x16.png"));
    //private final ImageIcon warning = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "warning16x16.png"));
    private final ImageIcon anonymousFace = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "face160x160.png"));
    private ImageIcon previewFace = null;
    
    public static final String ICON = "head28x28.png";
    public static final String NAME = "Face State";
    

    /**
     * Panel with face information
     * @param loadFaceListener ActionListener listens when load face button is clicked
     */
    public FaceStatePanel(ActionListener loadFaceListener) {
        
        this.setName(NAME);
        initComponents();
        loadFaceButton.addActionListener(loadFaceListener);
        //210 140

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        filePanel = new javax.swing.JPanel();
        pathLabel = new javax.swing.JLabel();
        sizeLabel = new javax.swing.JLabel();
        pathOutput = new javax.swing.JLabel();
        sizeOutput = new javax.swing.JLabel();
        facePanel = new javax.swing.JPanel();
        kdTreeLabel = new javax.swing.JLabel();
        featurePointsLoadedLabel = new javax.swing.JLabel();
        hasKDOutput = new javax.swing.JLabel();
        hasFPOutput = new javax.swing.JLabel();
        faceNotLoadedLabel = new javax.swing.JLabel();
        loadFaceButton = new javax.swing.JButton();
        warningLabel = new javax.swing.JLabel();
        photoPanel = new javax.swing.JPanel();
        photo = new javax.swing.JLabel();

        filePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.filePanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(pathLabel, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.pathLabel.text")); // NOI18N
        pathLabel.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(sizeLabel, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.sizeLabel.text")); // NOI18N
        sizeLabel.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(pathOutput, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.pathOutput.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(sizeOutput, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.sizeOutput.text")); // NOI18N

        javax.swing.GroupLayout filePanelLayout = new javax.swing.GroupLayout(filePanel);
        filePanel.setLayout(filePanelLayout);
        filePanelLayout.setHorizontalGroup(
            filePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(filePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(filePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(pathLabel)
                    .addComponent(sizeLabel))
                .addGap(49, 49, 49)
                .addGroup(filePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(sizeOutput)
                    .addComponent(pathOutput))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        filePanelLayout.setVerticalGroup(
            filePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(filePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(filePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(pathLabel)
                    .addComponent(pathOutput))
                .addGap(13, 13, 13)
                .addGroup(filePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(sizeLabel)
                    .addComponent(sizeOutput))
                .addContainerGap(41, Short.MAX_VALUE))
        );

        facePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.facePanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(kdTreeLabel, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.kdTreeLabel.text")); // NOI18N
        kdTreeLabel.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(featurePointsLoadedLabel, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.featurePointsLoadedLabel.text")); // NOI18N
        featurePointsLoadedLabel.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(hasKDOutput, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.hasKDOutput.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(hasFPOutput, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.hasFPOutput.text")); // NOI18N

        faceNotLoadedLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(faceNotLoadedLabel, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.faceNotLoadedLabel.text")); // NOI18N
        faceNotLoadedLabel.setVisible(false);

        loadFaceButton.setVisible(false);
        org.openide.awt.Mnemonics.setLocalizedText(loadFaceButton, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.loadFaceButton.text")); // NOI18N

        warningLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/warning16x16.png"))); // NOI18N
        warningLabel.setVisible(false);
        org.openide.awt.Mnemonics.setLocalizedText(warningLabel, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.warningLabel.text")); // NOI18N

        javax.swing.GroupLayout facePanelLayout = new javax.swing.GroupLayout(facePanel);
        facePanel.setLayout(facePanelLayout);
        facePanelLayout.setHorizontalGroup(
            facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(facePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(kdTreeLabel)
                    .addComponent(featurePointsLoadedLabel))
                .addGap(22, 22, 22)
                .addGroup(facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(hasFPOutput)
                    .addComponent(hasKDOutput))
                .addContainerGap(423, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, facePanelLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(warningLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(faceNotLoadedLabel)
                    .addComponent(loadFaceButton))
                .addGap(33, 33, 33))
        );
        facePanelLayout.setVerticalGroup(
            facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(facePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(kdTreeLabel)
                    .addComponent(hasKDOutput))
                .addGap(18, 18, 18)
                .addGroup(facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(featurePointsLoadedLabel)
                    .addComponent(hasFPOutput))
                .addGap(56, 56, 56)
                .addGroup(facePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(warningLabel)
                    .addComponent(faceNotLoadedLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(loadFaceButton)
                .addContainerGap(44, Short.MAX_VALUE))
        );

        photoPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.photoPanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12))); // NOI18N

        photo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/face160x160.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(photo, org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.photo.text")); // NOI18N
        photo.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                photoMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout photoPanelLayout = new javax.swing.GroupLayout(photoPanel);
        photoPanel.setLayout(photoPanelLayout);
        photoPanelLayout.setHorizontalGroup(
            photoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(photoPanelLayout.createSequentialGroup()
                .addGap(55, 55, 55)
                .addComponent(photo)
                .addGap(55, 55, 55))
        );
        photoPanelLayout.setVerticalGroup(
            photoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(photoPanelLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(photo)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(filePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(facePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(photoPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addComponent(photoPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(filePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(facePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        filePanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FaceStatePanel.class, "FaceStatePanel.filePanel.AccessibleContext.accessibleName")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void photoMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_photoMouseClicked
        
        if (previewFace != null) {
            JOptionPane.showMessageDialog(this.getParent(), previewFace, "Preview Image", JOptionPane.PLAIN_MESSAGE);
        }
       
    }//GEN-LAST:event_photoMouseClicked
    
    /**
     * Shows face information on panel
     * @param face HumanFace
     * @param name String
     * @param path Path
     */
    public void showFaceState(HumanFace face, String name, Path path) {
        
        photo.setIcon(getPhoto(face, path));
        pathOutput.setText(getPathText(path));
        sizeOutput.setText(getSizeText(path));
        hasKDOutput.setIcon(getKdTree(face));
        hasFPOutput.setIcon(getFeaturePoints(face));
        checkFaceLoaded(face);
    }
    
    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + ICON));
    }
    
    /**
     * Gets photo which would be displayed on photo panel
     * @param face HumanFace
     * @param path Path
     * @return ImageIcon either loaded face preview or anonymous face when preview is not found
     */
    private ImageIcon getPhoto(HumanFace face, Path path) {
        
        ImageIcon image;
        previewFace = null;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        
        if (face != null) {
            if (face.getPreview() != null) {
                previewFace = new ImageIcon(face.getPreview().getScaledInstance((int)screenSize.getWidth() - 100, (int)screenSize.getHeight() - 100, Image.SCALE_FAST));
                photo.setToolTipText("Click to enlarge the image");
                return new ImageIcon(face.getPreview().getScaledInstance(240, 160, Image.SCALE_FAST));
            }
            photo.setToolTipText("");
            return anonymousFace;
        }
        
        if (path != null && path.toFile().exists()) {
            
            String pathString = path.toString();
            Path preview = Paths.get(pathString.substring(0, pathString.lastIndexOf(".")).concat("_preview.jpg"));
                
            try {
                
                previewFace = new ImageIcon(ImageIO.read(preview.toFile()).getScaledInstance((int)screenSize.getWidth() - 200, (int)screenSize.getHeight() - 200, Image.SCALE_FAST));
                image = new ImageIcon(previewFace.getImage().getScaledInstance(240, 160, Image.SCALE_FAST));
                photo.setToolTipText("Click to enlarge the image");
                return image;
            } catch (IOException ex) {
                //Exceptions.printStackTrace(ex);)
            }
        }
        photo.setToolTipText("");
        return anonymousFace;
    }
    
    /**
     * Gets path text
     * @param path Path
     * @return String path
     */
    private String getPathText(Path path) {
        
        if (path != null) {
            pathLabel.setEnabled(true);
            return path.toString();
        }
        pathLabel.setEnabled(false);
        return "";
    }
    
    /**
     * Gets size of model ".obj"
     * @param path Path
     * @return String size in kB
     */
    private String getSizeText(Path path) {
        
        if (path != null && path.toFile().exists()) {

            try {
                long bytes = Files.size(path);
                sizeLabel.setEnabled(true);
                return String.format("%,d kB", bytes / 1024);
                
            } catch (IOException ex) {
                //Exceptions.printStackTrace(ex);
                // TODO HANDLE EXCEPTION
            }
        }
        sizeLabel.setEnabled(false);
        return "";
    }
    
    /**
     * Gets icon which shows if face has calculated KD-tree
     * @param face HumanFace
     * @return ImageIcon either check or notCheck
     */
    private ImageIcon getKdTree(HumanFace face) {
        if (face == null) {
            kdTreeLabel.setEnabled(false);
            return null;
        }
        
        kdTreeLabel.setEnabled(true);
        if (face.hasKdTree()) {
            return check;
        }
        return notCheck;
    }
    
    /**
     * Gets icon which shows if face has featurePoints
     * @param face HumanFace
     * @return ImageIcon either check or notCheck
     */
    private ImageIcon getFeaturePoints(HumanFace face) {
        
        if (face == null) {
            featurePointsLoadedLabel.setEnabled(false);
            return null;
        }
        
        featurePointsLoadedLabel.setEnabled(true);
        if (face.hasFeaturePoints() || face.findLandmarks() != null) {
            return check;
        }
        return notCheck;
    }
    
    /**
     * Checks whether face is loaded in project or not
     * If not, button which loads currently selected face to project shows up
     * @param face HumanFace
     */
    private void checkFaceLoaded(HumanFace face) {
        warningLabel.setVisible(face == null);
        faceNotLoadedLabel.setVisible(face == null);
        loadFaceButton.setVisible(face == null);
    }
    
    /**
     * All information is returned to basic value
     */
    public void deselectFace() {
        this.showFaceState(null, null, null);
        warningLabel.setVisible(false);
        faceNotLoadedLabel.setVisible(false);
        loadFaceButton.setVisible(false);
    }
    
    /**
     * Face from list is (de)selected
     * @param selected true if face is selected, false if deselected
     * @param face HumanFace
     * @param name String name of face
     * @param path Path to face
     */
    public void newSelection(boolean selected, HumanFace face, String name, Path path) {
        
        if (selected) {
            this.showFaceState(face, name, path);
        } else {
            this.deselectFace();
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel faceNotLoadedLabel;
    private javax.swing.JPanel facePanel;
    private javax.swing.JLabel featurePointsLoadedLabel;
    private javax.swing.JPanel filePanel;
    private javax.swing.JLabel hasFPOutput;
    private javax.swing.JLabel hasKDOutput;
    private javax.swing.JLabel kdTreeLabel;
    private javax.swing.JButton loadFaceButton;
    private javax.swing.JLabel pathLabel;
    private javax.swing.JLabel pathOutput;
    private javax.swing.JLabel photo;
    private javax.swing.JPanel photoPanel;
    private javax.swing.JLabel sizeLabel;
    private javax.swing.JLabel sizeOutput;
    private javax.swing.JLabel warningLabel;
    // End of variables declaration//GEN-END:variables

}
