package cz.fidentis.analyst.symmetry;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.scene.DrawablePlane;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

/**
 * Action listener for the manipulation with the symmetry plane.
 * 
 * @author Radek Oslejsek
 */
public class SymmetryAction extends AbstractAction {
    
    public static final String ACTION_COMMAND_SHOW_HIDE_PLANE = "show-hide symmetry plane";
    public static final String ACTION_COMMAND_SHOW_HIDE_PANEL = "show-hide symmetry control panel";
    public static final String ACTION_COMMAND_RECOMPUTE = "recompute";
    
    private final SymmetryPanel controlPanel;
    private final JTabbedPane topControlPanel;
    private final Canvas canvas;
    
    /**
     * Constructor.
     * 
     * @param topControlPanel Top component for placing control panels
     * @param canvas OpenGL canvas
     */
    public SymmetryAction(JTabbedPane topControlPanel, Canvas canvas) {
        this.canvas = canvas;
        this.controlPanel = new SymmetryPanel(this);
        this.topControlPanel = topControlPanel;
        //this.topControlPanel.add(controlPanel);
        //controlPanel.setVisible(false);
        //topControlPanel.addTab("tab1", new JPanel());
    }
    
    @Override
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        DrawablePlane plane;
        
        switch (action) {
            case ACTION_COMMAND_SHOW_HIDE_PLANE:
                plane = canvas.getScene().getDrawableSymmetryPlane(0);
                if (plane == null) { // no plane compute so far
                    break;
                }
                if (((JToggleButton) ae.getSource()).isSelected()) {
                    plane.show();
                } else {
                    plane.hide();
                }
                break;
            case ACTION_COMMAND_SHOW_HIDE_PANEL:
                if (((JToggleButton) ae.getSource()).isSelected()) {
                    topControlPanel.addTab(SymmetryPanel.NAME, SymmetryPanel.ICON, controlPanel);
                    topControlPanel.setSelectedComponent(controlPanel); // focus
                } else {
                    topControlPanel.remove(controlPanel);
                }
                break;
            case ACTION_COMMAND_RECOMPUTE: 
                recomputeSymmetryPlane();
                //canvas.getScene().getDrawableSymmetryPlane(0).show();
                break;  
            default:
                throw new UnsupportedOperationException(action);
        }
        canvas.renderScene();
    }
    
    private void recomputeSymmetryPlane() {
        //setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
        //controlPanel.confirmConfigParams();
        SymmetryEstimator se = new SymmetryEstimator(controlPanel.getSymmetryConfig());
        canvas.getScene().getDrawableFace(0).getModel().compute(se);
        DrawablePlane plane = new DrawablePlane(se.getSymmetryPlaneMesh(), se.getSymmetryPlane());
        canvas.getScene().setDrawableSymmetryPlane(0, plane);
    }
    
}
