package cz.fidentis.analyst.gui.scene;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import java.awt.Color;
import java.util.List;
import javax.vecmath.Vector3f;

/**
 * A drawable triangular mesh, i.e., a mesh model with drawing information like 
 * material, transparency, color, relative transformations in the scene etc. 
 * This class encapsulates rendering state and parameters,
 * 
 * @author Radek Oslejsek
 */
public class DrawableMesh {
    
    private final MeshModel model;
    
    private boolean display = true;
    
    // TO DO - R. Pajersky: add transformation attributes and methods
    private Color color = new Color(255, 255, 255);
    private float transparency = 1f;
    private Vector3f translation = new Vector3f(0, 0, 0);
    private Vector3f rotation = new Vector3f(0, 0, 0);
    private Vector3f scale = new Vector3f(0, 0, 0);
    
    /**
     * Constructor. 
     * 
     * @param model Drawable mesh model
     * @throws IllegalArgumentException if the model is {@code null}
     */
    public DrawableMesh(MeshModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
    }
    
    /**
     * Returns list of individual facets.
     * 
     * @return list of individual facets.
     */
    public List<MeshFacet> getFacets() {
        return model.getFacets();
    }
    
    /**
     * This drawable mesh is included in the rendered scene.
     */
    public void show() {
        display = true;
    }
    
    /**
     * This drawable mesh is excluded from the rendered scene (skipped).
     */
    public void hide() {
        display = false;
    }
    
    /**
     * 
     * @return {@code true} if the object is included (rendered) in the scene.
     */
    public boolean isShown() {
        return display;
    }
    
    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return color;
    }
    
    public float getTransparency() {
        return transparency;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }
    
    public Vector3f getTranslation() {
        return translation;
    }

    public void setTranslation(Vector3f translation) {
        this.translation = translation;
    }

    public Vector3f getRotation() {
        return rotation;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public Vector3f getScale() {
        return scale;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }
    
    /*public void increaseXTranslation(float value) {
        this.translation.x = this.translation.x + value;
    }
    
    public void increaseYTranslation(float value) {
        this.translation.y = this.translation.y + value;
    }
    
    public void increaseZTranslation(float value) {
        this.translation.z = this.translation.z + value;
    }
    
    public void increaseXRotation(float value) {
        this.rotation.x = this.rotation.x + value;
    }
    
    public void increaseYRotation(float value) {
        this.rotation.y = this.rotation.y + value;
    }
    
    public void increaseZRotation(float value) {
        this.rotation.z = this.rotation.z + value;
    }
    
    public void increaseXScale(float value) {
        this.scale.x = this.scale.x + value;
    }
    
    public void increaseYScale(float value) {
        this.scale.y = this.scale.y + value;
    }
    
    public void increaseZScale(float value) {
        this.scale.z = this.scale.z + value;
    }*/
    
    public void resetTranslation() {
        this.translation = new Vector3f(0, 0, 0);
    }
    
    public void resetRotation() {
        this.rotation = new Vector3f(0, 0, 0);
    }
        
    public void resetScale() {
        this.scale = new Vector3f(0, 0, 0);
    }
}
