/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.gui.canvas.Canvas;
import cz.fidentis.analyst.gui.scene.DrawableMesh;
import cz.fidentis.analyst.gui.scene.Scene;
import java.awt.Color;
import java.util.ArrayList;

/**
 *
 * @author Richard Pajersky
 */
public class RegistrationCPEventListener {
    //private final Scene scene;
    private final Canvas canvas;
    
    private final Color defaultPrimaryColor = new Color(51, 51, 153);
    private final Color defaultSecondaryColor = new Color(255, 239, 0);
    
    private DrawableMesh primaryFace;
    private DrawableMesh secondaryFace;

    public RegistrationCPEventListener(Canvas canvas) {
        this.canvas = canvas;
        
        ArrayList<DrawableMesh> drawables = new ArrayList<>(canvas.getScene().getDrawables());
        primaryFace = drawables.get(0);
        secondaryFace = drawables.get(1);
        setDeafultColor();
    }
    
    public final void setDeafultColor() {
        primaryFace.setColor(defaultPrimaryColor);
        secondaryFace.setColor(defaultSecondaryColor);
    }
    
    public void setPrimaryColor(Color color) {
        primaryFace.setColor(color);
        canvas.renderScene();
    }

    public void setSecondaryColor(Color color) {
        secondaryFace.setColor(color);
        canvas.renderScene();
    }
    
    public Color getPrimaryColor() {
        return primaryFace.getColor();
    }

    public Color getSecondaryColor() {
        return secondaryFace.getColor();
    }
    
    public void setTransparency(int value) {
        if (value == 10) {
            setPrimaryTransparency(1f);
            setSecondaryTransparency(1f);
        }
        if (value < 10) {
            setPrimaryTransparency(value / 10f);
            setSecondaryTransparency(1f);
        }
        if (value > 10) {
            setSecondaryTransparency((10 - (value - 10)) / 10f);
            setPrimaryTransparency(1f);
        }
        canvas.renderScene();
    }
    
    public void setPrimaryTransparency(float transparency) {
        primaryFace.setTransparency(transparency);
    }

    public void setSecondaryTransparency(float transparency) {
        secondaryFace.setTransparency(transparency);
    }
    
    public float getPrimaryTransparency() {
        return primaryFace.getTransparency();
    }

    public float getSecondaryTransparency() {
        return secondaryFace.getTransparency();
    }
    
    public void setFrontFacing() {
        canvas.getCamera().initLocation();
        canvas.renderScene();
    }
    
    public void setSideFacing() {
        canvas.getCamera().initLocation();
        canvas.getCamera().rotate(0, 90);
        canvas.renderScene();
    }
    
    public Color getDefaultPrimaryColor() {
        return defaultPrimaryColor;
    }

    public Color getDefaultSecondaryColor() {
        return defaultSecondaryColor;
    }
    
    public void resetTranslation() {
        secondaryFace.resetTranslation();
    }
    
    public void resetRotation() {
        secondaryFace.resetRotation();
    }

    public void resetScale() {
        secondaryFace.resetScale();
    }
}
