package cz.fidentis.analyst.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionReferences;
import org.openide.awt.ActionRegistration;
import org.openide.util.NbBundle.Messages;

/**
 *
 * @author Natalia Bebjakova 
 * 
 * Symmetry estimator.
 */

@ActionID(
        category = "File",
        id = "cz.fidentis.analyst.gui.SymmetryEstimator"
)
@ActionRegistration(
        iconBase = "symmetry16x16.png",
        displayName = "#CTL_SymmetryEstimator"
)
@ActionReferences({
    @ActionReference(path = "Menu/Edit", position = 2600, separatorBefore = 2550),
    @ActionReference(path = "Toolbars/File", position = 300)
})
@Messages("CTL_SymmetryEstimator=Symmetry Estimator")
public final class SymmetryEstimator implements ActionListener {

    /**
     * Flag for whether the symmetry plane should be displayed
     */
    boolean symmetryPlaneClicked = false;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (symmetryPlaneClicked) {
            symmetryPlaneClicked = false;
            Canvas.setDrawSymmetryPlane(symmetryPlaneClicked);
        } else {
            symmetryPlaneClicked = true;
            Canvas.setDrawSymmetryPlane(symmetryPlaneClicked);
        }
    }
}
