/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.exception.FeaturePointException;
import cz.fidentis.analyst.feature.provider.FeaturePointTypeProvider;
import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * Class used to import feature points from file of fp format
 * 
 * @author kubok
 */
public class FeaturePointsFpLoader {

    private static final String GREATER_THAN_DELIMETER = ">";
    private static final String LESS_THAN_DELIMETER = "<";

    public Optional<List<FeaturePoint>> importFeaturePointsFP(String path, String fileName) {
        FileResourcesUtils app = new FileResourcesUtils();
        try (InputStreamReader streamReader
                = new InputStreamReader(app.getFileAsStream(path, fileName), StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(streamReader)) {

            Stream<String> lines = reader.lines();
            List<String> linesList = new ArrayList<>();

            lines.forEach(line -> {
                linesList.add(line);
            });

            if (linesList.isEmpty()) {
                throw new FeaturePointException(String.format("Feature point import file '%s' has wrong format", fileName));
            }

            List<FeaturePoint> points = new ArrayList<>();
            for (int i = 1; i < linesList.size() - 6; i += 5) {
                FeaturePoint point = new FeaturePoint(
                        Double.parseDouble(linesList.get(i + 1).substring(
                                linesList.get(i + 1).indexOf(GREATER_THAN_DELIMETER) + 1,
                                linesList.get(i + 1).indexOf(LESS_THAN_DELIMETER, linesList.get(i + 1).indexOf(GREATER_THAN_DELIMETER)))),
                        Double.parseDouble(linesList.get(i + 2).substring(
                                linesList.get(i + 2).indexOf(GREATER_THAN_DELIMETER) + 1,
                                linesList.get(i + 2).indexOf(LESS_THAN_DELIMETER, linesList.get(i + 2).indexOf(GREATER_THAN_DELIMETER)))),
                        Double.parseDouble(linesList.get(i + 3).substring(
                                linesList.get(i + 3).indexOf(GREATER_THAN_DELIMETER) + 1,
                                linesList.get(i + 3).indexOf(LESS_THAN_DELIMETER, linesList.get(i + 3).indexOf(GREATER_THAN_DELIMETER)))),
                        FeaturePointTypeProvider.getInstance().getFeaturePointTypeById(
                                Integer.parseInt(linesList.get(i).replaceAll("[^0-9]", "")))
                );
                points.add(point);
            }
            return Optional.of(points);

        } catch (IOException e) {
            throw new FeaturePointException(String.format("Feature point service cannot open file", fileName));
        } catch (NumberFormatException e1) {
            throw new FeaturePointException(e1.getMessage());
        }
    }
}
